<?php

namespace Modules\Mosque\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use Modules\Mosque\Entities\MosqueSetting;
use Modules\Mosque\Services\TenancyBillingService;

class TenancyAutoBill
{
    public function handle(Request $request, Closure $next)
    {
        try {
            if (! auth()->check()) {
                return $next($request);
            }

            // Only on non-AJAX GET page hits to avoid slowing down DataTables/actions.
            if (! $request->isMethod('GET') || $request->ajax() || $request->expectsJson()) {
                return $next($request);
            }

            if (defined('MOSQUE_TENANCY_AUTOBILL_RAN') && MOSQUE_TENANCY_AUTOBILL_RAN) {
                return $next($request);
            }

            $businessId = (int) $request->session()->get('user.business_id');
            if ($businessId <= 0) {
                return $next($request);
            }

            if (! Schema::hasTable('mosque_settings')) {
                return $next($request);
            }

            $settings = (MosqueSetting::query()->where('business_id', $businessId)->value('settings')) ?: [];
            $enabled = (bool) ($settings['tenancy_enabled'] ?? true);
            $mode = (string) ($settings['tenancy_billing_mode'] ?? 'manual');

            if (! $enabled || $mode !== 'auto_lazy') {
                return $next($request);
            }

            define('MOSQUE_TENANCY_AUTOBILL_RAN', true);
            TenancyBillingService::generateDueBills($businessId, [
                'max_allocations' => 100,
                'send_notices' => true,
            ]);
        } catch (\Throwable $e) {
            // Non-blocking.
        }

        return $next($request);
    }
}

