<?php

namespace Modules\Mosque\Providers;

use Illuminate\Support\Facades\File;
use Illuminate\Support\ServiceProvider;

class MosqueServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');

        // Ensure required upload directories exist (Bridge/Ultimate POS uses `public/uploads/*`).
        $dir = public_path('uploads/mosque_staff_photos');
        if (! File::isDirectory($dir)) {
            File::makeDirectory($dir, 0755, true);
        }
    }

    public function register(): void
    {
        $this->app->register(RouteServiceProvider::class);
    }

    protected function registerConfig(): void
    {
        $this->publishes([
            __DIR__ . '/../Config/config.php' => config_path('mosque.php'),
        ], 'config');
        $this->mergeConfigFrom(__DIR__ . '/../Config/config.php', 'mosque');
    }

    public function registerViews(): void
    {
        $viewPath = resource_path('views/modules/mosque');
        $sourcePath = __DIR__ . '/../Resources/views';

        $this->publishes([
            $sourcePath => $viewPath,
        ], 'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/mosque';
        }, config('view.paths')), [$sourcePath]), 'mosque');
    }

    public function registerTranslations(): void
    {
        $langPath = resource_path('lang/modules/mosque');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'mosque');
        } else {
            $this->loadTranslationsFrom(__DIR__ . '/../Resources/lang', 'mosque');
        }
    }

    public function provides(): array
    {
        return [];
    }
}
