@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.activate_title'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
        @lang('mosque::mosque.activate_title')
    </h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <form method="post" action="{{ route('mosque.activate.store') }}">
            {{ csrf_field() }}

            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="mosque_username">@lang('mosque::mosque.username')</label>
                        <input id="mosque_username" type="text" name="username" value="{{ old('username') }}" class="form-control" required>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="mosque_license">@lang('mosque::mosque.license')</label>
                        <input id="mosque_license" type="text" name="license" value="{{ old('license') }}" class="form-control" required>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white pull-right">@lang('mosque::mosque.activate')</button>
                </div>
            </div>
        </form>
    @endcomponent
</section>
@endsection
