@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_assets'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_assets')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs">
            <li class="active"><a href="#tab_assets" data-toggle="tab">Assets</a></li>
            <li><a href="#tab_maintenance" data-toggle="tab">Maintenance</a></li>
            <li><a href="#tab_properties" data-toggle="tab">Properties</a></li>
            <li><a href="#tab_rentals" data-toggle="tab">Rentals</a></li>
            <li><a href="#tab_reports" data-toggle="tab">@lang('mosque::mosque.menu_assets_reports')</a></li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div class="tab-pane active" id="tab_assets">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.assets.assets.create', [], false) }}" data-container=".mosque_asset_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_assets_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Tag</th>
                                <th>Acquired</th>
                                <th>Value</th>
                                <th>Status</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_maintenance">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.assets.maintenance.create', [], false) }}" data-container=".mosque_maintenance_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_maintenance_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Asset</th>
                                <th>Date</th>
                                <th>Cost</th>
                                <th>Remark</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_properties">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.assets.properties.create', [], false) }}" data-container=".mosque_property_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_properties_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>@lang('business.address')</th>
                                <th>Rentable</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_rentals">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.assets.rentals.create', [], false) }}" data-container=".mosque_rental_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_rentals_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Property</th>
                                <th>Tenant</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Rent</th>
                                <th>Paid</th>
                                <th>Status</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_reports">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('lang_v1.start_date')</label>
                            <input type="date" id="mar_start_date" class="form-control" value="{{ now()->startOfMonth()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('lang_v1.end_date')</label>
                            <input type="date" id="mar_end_date" class="form-control" value="{{ now()->endOfMonth()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Property ID</label>
                            <input type="number" id="mar_property_id" class="form-control" placeholder="optional">
                            <p class="help-block">Used on Rentals Income.</p>
                        </div>
                    </div>
                </div>

                <ul class="nav nav-pills" style="margin-bottom:10px;">
                    <li class="active"><a href="#tab_reports_status" data-toggle="tab">Assets Status</a></li>
                    <li><a href="#tab_reports_maintenance" data-toggle="tab">Maintenance Summary</a></li>
                    <li><a href="#tab_reports_rentals" data-toggle="tab">Rentals Income</a></li>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_reports_status">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_assets_status_report_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Status</th>
                                        <th>Assets</th>
                                        <th>Total Value</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>

                    <div class="tab-pane" id="tab_reports_maintenance">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_assets_maintenance_report_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Asset</th>
                                        <th>Tag</th>
                                        <th>Jobs</th>
                                        <th>Total Cost</th>
                                        <th>Last Maintenance</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>

                    <div class="tab-pane" id="tab_reports_rentals">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_assets_rentals_report_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Month</th>
                                        <th>Property</th>
                                        <th>Rentals</th>
                                        <th>Rent Total</th>
                                        <th>Paid Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endcomponent

    <div class="modal fade mosque_asset_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_maintenance_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_property_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_rental_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var assets_table = $('#mosque_assets_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.assets.assets.data", [], false) }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'tag_no', name: 'tag_no' },
                { data: 'acquired_on', name: 'acquired_on' },
                { data: 'value', name: 'value', orderable: false, searchable: false },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_assets_table')); }
        });

        var maintenance_table = $('#mosque_maintenance_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.assets.maintenance.data", [], false) }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'asset_name', name: 'asset_name' },
                { data: 'date', name: 'date' },
                { data: 'cost', name: 'cost', orderable: false, searchable: false },
                { data: 'remark', name: 'remark' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_maintenance_table')); }
        });

        var properties_table = $('#mosque_properties_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.assets.properties.data", [], false) }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'address', name: 'address', orderable: false },
                { data: 'rentable', name: 'rentable', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });

        var rentals_table = $('#mosque_rentals_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.assets.rentals.data", [], false) }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'property_name', name: 'property_name' },
                { data: 'tenant_name', name: 'tenant_name' },
                { data: 'from_date', name: 'from_date' },
                { data: 'to_date', name: 'to_date' },
                { data: 'rent_amount', name: 'rent_amount', orderable: false, searchable: false },
                { data: 'paid_amount', name: 'paid_amount', orderable: false, searchable: false },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_rentals_table')); }
        });

        function getAssetsReportFilters() {
            return {
                start_date: $('#mar_start_date').val(),
                end_date: $('#mar_end_date').val(),
                property_id: $('#mar_property_id').val(),
            };
        }

        var assets_status_report_table = $('#mosque_assets_status_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: { url: '{{ route("mosque.assets.reports.status", [], false) }}' },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'status', name: 'status' },
                { data: 'assets_count', name: 'assets_count', searchable: false },
                { data: 'total_value', name: 'total_value', orderable: false, searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_assets_status_report_table')); }
        });

        var maintenance_report_table = $('#mosque_assets_maintenance_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.assets.reports.maintenance", [], false) }}',
                data: function (d) { return $.extend({}, d, getAssetsReportFilters()); }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'asset_name', name: 'asset_name' },
                { data: 'tag_no', name: 'tag_no' },
                { data: 'jobs_count', name: 'jobs_count', searchable: false },
                { data: 'total_cost', name: 'total_cost', orderable: false, searchable: false },
                { data: 'last_maintenance_date', name: 'last_maintenance_date', searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_assets_maintenance_report_table')); }
        });

        var rentals_report_table = $('#mosque_assets_rentals_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.assets.reports.rentals", [], false) }}',
                data: function (d) { return $.extend({}, d, getAssetsReportFilters()); }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'month_ym', name: 'month_ym' },
                { data: 'property_name', name: 'property_name' },
                { data: 'rentals_count', name: 'rentals_count', searchable: false },
                { data: 'rent_total', name: 'rent_total', orderable: false, searchable: false },
                { data: 'paid_total', name: 'paid_total', orderable: false, searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_assets_rentals_report_table')); }
        });

        function ajaxForm(selector, modalSelector, tables) {
            $(document).on('submit', selector, function (e) {
                e.preventDefault();
                var $form = $(this);
                $.ajax({
                    method: $form.find('input[name=_method]').val() || $form.attr('method'),
                    url: $form.attr('action'),
                    data: $form.serialize(),
                    success: function (result) {
                        if (result.success) {
                            $(modalSelector).modal('hide');
                            toastr.success(result.msg);
                            tables.forEach(function (t) { t.ajax.reload(); });
                        } else {
                            toastr.error(result.msg);
                        }
                    },
                    error: function () { toastr.error('@lang("messages.something_went_wrong")'); }
                });
            });
        }

        ajaxForm('form#mosque_asset_form', '.mosque_asset_modal', [assets_table]);
        ajaxForm('form#mosque_maintenance_form', '.mosque_maintenance_modal', [maintenance_table]);
        ajaxForm('form#mosque_property_form', '.mosque_property_modal', [properties_table]);
        ajaxForm('form#mosque_rental_form', '.mosque_rental_modal', [rentals_table]);

        $(document).on('change', '#mar_start_date, #mar_end_date, #mar_property_id', function () {
            maintenance_report_table.ajax.reload();
            rentals_report_table.ajax.reload();
        });

    });
</script>
@endsection
