<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.assets.rentals.update', $rental->id), 'method' => 'post', 'id' => 'mosque_rental_form']) !!}
        {!! Form::hidden('_method', 'PUT') !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.edit')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('property_id', 'Property:*') !!}
                        {!! Form::select('property_id', $properties, $rental->property_id, ['class' => 'form-control', 'required', 'placeholder' => __('lang_v1.none')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('tenant_name', 'Tenant Name:*') !!}
                        {!! Form::text('tenant_name', $rental->tenant_name, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('from_date', 'From:*') !!}
                        {!! Form::date('from_date', !empty($rental->from_date) ? $rental->from_date->format('Y-m-d') : null, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('to_date', 'To:') !!}
                        {!! Form::date('to_date', !empty($rental->to_date) ? $rental->to_date->format('Y-m-d') : null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('rent_amount', 'Rent Amount:*') !!}
                        {!! Form::number('rent_amount', $rental->rent_amount, ['class' => 'form-control', 'step' => '0.01', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('paid_amount', 'Paid Amount:') !!}
                        {!! Form::number('paid_amount', $rental->paid_amount, ['class' => 'form-control', 'step' => '0.01']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('status', 'Status:') !!}
                        {!! Form::text('status', $rental->status, ['class' => 'form-control']) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

