<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Rental Agreement - {{ $property->name }} - #{{ $rental->id }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { display:flex; justify-content: flex-end; gap: 8px; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; display:flex; justify-content: space-between; gap: 12px; align-items: center; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid td { padding: 7px 6px; vertical-align: top; }
        .label { width: 180px; color: #333; font-weight: bold; }
        .box { border: 1px solid #ddd; padding: 10px; border-radius: 4px; margin-top: 12px; font-size: 12px; }
        .signs { display:flex; gap: 20px; margin-top: 18px; }
        .sig { width: 50%; border-top: 1px solid #333; padding-top: 6px; font-size: 12px; color: #333; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;
        $logoFallbackUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try {
                $logoFallbackUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo);
            } catch (\Exception $e) { $logoFallbackUrl = null; }
        }
        $logoSrc = $logoDataUri ?? $logoFallbackUrl;
        $settings = $settings ?? [];
    @endphp

    <div class="header">
        <div>
            <h1>Rental Agreement / Receipt</h1>
            <div class="muted">{{ $headerName }} &nbsp;|&nbsp; Property: {{ $property->name }} &nbsp;|&nbsp; Rental #{{ $rental->id }}</div>
        </div>
        @if(!empty($logoSrc))
            <div><img src="{{ $logoSrc }}" alt="Logo" style="max-height:60px;"></div>
        @endif
    </div>

    <table class="grid">
        <tr>
            <td class="label">Tenant</td>
            <td>{{ $rental->tenant_name }}</td>
        </tr>
        <tr>
            <td class="label">Property</td>
            <td>{{ $property->name }}</td>
        </tr>
        <tr>
            <td class="label">Property Address</td>
            <td>{{ $property->address ?? '-' }}</td>
        </tr>
        <tr>
            <td class="label">From Date</td>
            <td>{{ !empty($rental->from_date) ? \Carbon\Carbon::parse($rental->from_date)->format('Y-m-d') : '-' }}</td>
        </tr>
        <tr>
            <td class="label">To Date</td>
            <td>{{ !empty($rental->to_date) ? \Carbon\Carbon::parse($rental->to_date)->format('Y-m-d') : '-' }}</td>
        </tr>
        <tr>
            <td class="label">Rent Amount</td>
            <td><strong>{{ \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($rental->rent_amount, $settings) }}</strong></td>
        </tr>
        <tr>
            <td class="label">Paid Amount</td>
            <td><strong>{{ \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($rental->paid_amount, $settings) }}</strong></td>
        </tr>
        <tr>
            <td class="label">Status</td>
            <td>{{ $rental->status ?? '-' }}</td>
        </tr>
    </table>

    <div class="box">
        <strong>Terms</strong><br>
        This document is generated by the Mosque module for record keeping. Any additional terms should be maintained by the mosque administration.
    </div>

    @if(!empty($profile) && !empty($profile->header_text))
        <div class="box">
            {!! nl2br(e($profile->header_text)) !!}
        </div>
    @endif

    <div class="signs">
        <div class="sig">Authorized Signature (Mosque)</div>
        <div class="sig">Tenant Signature</div>
    </div>
</body>
</html>
