@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | QR Attendance')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">QR Attendance</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        @if(empty($enabled))
            <div class="alert alert-warning">
                QR attendance is disabled. Enable it from <a href="{{ route('mosque.settings') }}">Mosque Settings</a>.
            </div>
        @else
            <div class="row">
                <div class="col-sm-6">
                    <p class="text-muted">Print this QR and place it at the mosque entrance. Staff will scan and enter their Staff ID.</p>
                    <p><strong>Scan URL:</strong> <a href="{{ $scanUrl }}" target="_blank">{{ $scanUrl }}</a></p>

                    <form method="post" action="{{ route('mosque.attendance.qr.regenerate') }}" style="display:inline-block;">
                        {{ csrf_field() }}
                        <button type="submit" class="btn btn-danger"><i class="fa fa-refresh"></i> Regenerate QR</button>
                    </form>
                </div>
                <div class="col-sm-6 text-center">
                    @if(!empty($qrCode))
                        <img id="qr_image" src="{{ $qrCode }}" alt="QR" class="mw-100" style="max-width: 260px;">
                        <div style="margin-top:10px;">
                            <a id="download_qr" href="{{ $qrCode }}" class="btn btn-success" download="mosque_qr_attendance.png">
                                <i class="fa fa-download"></i> Download
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        @endif
    @endcomponent
</section>
@endsection
