<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $title }}</title>
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <style>
        body { font-family: Arial, sans-serif; padding: 16px; }
        .wrap { max-width: 520px; margin: 0 auto; }
        .btn-primary { background: {{ $primaryColor }}; border-color: {{ $primaryColor }}; }
        .muted { color: #666; font-size: 12px; }
    </style>
</head>
<body>
    <div class="wrap">
        <h3 style="margin-top:0;">{{ $title }}</h3>
        <p class="muted">Enter your Staff ID then submit. The system will clock-in or clock-out automatically.</p>

        <div id="msg_box"></div>

        <form id="mosque_qr_attendance_form" method="post" action="{{ route('mosque.qr.submit', [$token]) }}">
            {{ csrf_field() }}
            <div class="form-group">
                <label>Staff ID</label>
                <input type="number" class="form-control" name="staff_id" required min="1" inputmode="numeric">
            </div>
            <input type="hidden" name="latitude" id="qr_latitude">
            <input type="hidden" name="longitude" id="qr_longitude">

            <button type="submit" class="btn btn-primary btn-block">Submit Attendance</button>
        </form>

        <hr>
        <p class="muted">If location permission is allowed, your coordinates may be captured for audit.</p>
    </div>

    <script src="{{ asset('js/app.js') }}"></script>
    <script>
        (function () {
            function setMsg(type, text) {
                var box = document.getElementById('msg_box');
                box.innerHTML = '<div class="alert alert-' + type + '">' + text + '</div>';
            }

            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (pos) {
                    document.getElementById('qr_latitude').value = pos.coords.latitude;
                    document.getElementById('qr_longitude').value = pos.coords.longitude;
                }, function () {}, { enableHighAccuracy: true, timeout: 6000, maximumAge: 0 });
            }

            var form = document.getElementById('mosque_qr_attendance_form');
            form.addEventListener('submit', function (e) {
                e.preventDefault();
                var data = new FormData(form);

                fetch(form.action, {
                    method: 'POST',
                    headers: { 'X-Requested-With': 'XMLHttpRequest' },
                    body: data
                }).then(function (r) { return r.json(); })
                  .then(function (json) {
                      if (json && json.success) {
                          setMsg('success', json.msg || 'Success');
                          form.reset();
                      } else {
                          setMsg('danger', (json && json.msg) ? json.msg : 'Something went wrong');
                      }
                  }).catch(function () {
                      setMsg('danger', 'Something went wrong');
                  });
            });
        })();
    </script>
</body>
</html>

