@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.permission_audit_view'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Audit Logs</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('lang_v1.start_date')</label>
                    <input type="date" id="ma_start_date" class="form-control">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('lang_v1.end_date')</label>
                    <input type="date" id="ma_end_date" class="form-control">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Action</label>
                    <select id="ma_action" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="create">create</option>
                        <option value="update">update</option>
                        <option value="delete">delete</option>
                        <option value="activate">activate</option>
                        <option value="deactivate">deactivate</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Entity</label>
                    <input type="text" id="ma_entity" class="form-control" placeholder="e.g. member, donation">
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_audit_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Date/Time</th>
                        <th>Action</th>
                        <th>Entity</th>
                        <th>Entity ID</th>
                        <th>Actor</th>
                        <th>IP</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(document).ready(function () {
    var table = $('#mosque_audit_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.audit.data") }}',
            data: function (d) {
                d.start_date = $('#ma_start_date').val();
                d.end_date = $('#ma_end_date').val();
                d.action = $('#ma_action').val();
                d.entity = $('#ma_entity').val();
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        order: [[0, 'desc']],
        columns: [
            { data: 'created_at', name: 'created_at' },
            { data: 'action', name: 'action' },
            { data: 'entity', name: 'entity' },
            { data: 'entity_id', name: 'entity_id' },
            { data: 'actor_id', name: 'actor_id' },
            { data: 'ip', name: 'ip' },
        ],
    });

    table.on('init.dt', function () {
        $('#mosque_audit_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });

    $(document).on('change', '#ma_start_date, #ma_end_date, #ma_action', function () {
        table.ajax.reload();
    });
    var mosqueAuditEntityTimer = null;
    $(document).on('keyup', '#ma_entity', function () {
        if (mosqueAuditEntityTimer) {
            clearTimeout(mosqueAuditEntityTimer);
        }
        mosqueAuditEntityTimer = setTimeout(function () {
            table.ajax.reload();
        }, 350);
    });
});
</script>
@endsection
