@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Reminders')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Reminders</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <p class="text-muted">Sends emails only (uses your system mail configuration). All actions are logged in Audit Logs.</p>
    @endcomponent

    <div class="row">
        <div class="col-sm-6">
            @component('components.widget', ['class' => 'box-primary'])
                <h4>Membership Due Reminders</h4>
                <p>
                    <strong>Enabled:</strong> {{ !empty($settings['reminders_membership_enabled']) ? __('lang_v1.yes') : __('lang_v1.no') }}<br>
                    <strong>Due this month:</strong> {{ (int) $dueCount }}<br>
                    <strong>Total due (this month):</strong>
                    <span class="display_currency" data-currency_symbol="true" data-orig-value="{{ (float) $dueTotal }}">{{ (float) $dueTotal }}</span>
                </p>

                <form method="post" action="{{ route('mosque.automation.reminders.membership.send') }}">
                    {{ csrf_field() }}
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Period (YYYY-MM)</label>
                                <input type="text" name="period_ym" class="form-control" value="{{ $periodYm }}" placeholder="2025-12" required>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Limit</label>
                                <input type="number" name="limit" class="form-control" value="100" min="1" max="500">
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Send Membership Reminders</button>
                </form>
            @endcomponent
        </div>

        <div class="col-sm-6">
            @component('components.widget', ['class' => 'box-primary'])
                <h4>Donation Reminders</h4>
                <p>
                    <strong>Enabled:</strong> {{ !empty($settings['reminders_donations_enabled']) ? __('lang_v1.yes') : __('lang_v1.no') }}<br>
                    <strong>Donors with email:</strong> {{ (int) $donorCount }}
                </p>

                <form method="post" action="{{ route('mosque.automation.reminders.donations.send') }}">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <label>Limit</label>
                        <input type="number" name="limit" class="form-control" value="200" min="1" max="1000">
                    </div>
                    <button type="submit" class="btn btn-primary">Send Donation Reminders</button>
                </form>
            @endcomponent
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        __currency_convert_recursively($('.content'));
    });
</script>
@endsection
