<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.committee.committees.update', $committee->id), 'method' => 'post', 'id' => 'mosque_committee_form']) !!}
        {!! Form::hidden('_method', 'PUT') !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.edit')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('name', 'Committee Name:*') !!}
                        {!! Form::text('name', $committee->name, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('term_start', 'Term Start:') !!}
                        {!! Form::date('term_start', !empty($committee->term_start) ? $committee->term_start->format('Y-m-d') : null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('term_end', 'Term End:') !!}
                        {!! Form::date('term_end', !empty($committee->term_end) ? $committee->term_end->format('Y-m-d') : null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('notes', $committee->notes, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

