@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Executive Committee')

@section('css')
    @parent
    <style>
        /* Fix label contrast inside widget backgrounds */
        .mosque-committee-filters label { color: #111827 !important; }
        .mosque-committee-filters .help-block { color: rgba(17, 24, 39, 0.70); }
    </style>
@endsection

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_committee')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs">
            <li class="active"><a href="#tab_committees" data-toggle="tab">Committees</a></li>
            <li><a href="#tab_members" data-toggle="tab">Members</a></li>
            <li><a href="#tab_roles" data-toggle="tab">@lang('mosque::mosque.committee_roles')</a></li>
            <li><a href="#tab_minutes" data-toggle="tab">Minutes</a></li>
            <li><a href="#tab_reports" data-toggle="tab">@lang('mosque::mosque.menu_committee_reports')</a></li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div class="tab-pane active" id="tab_committees">
                <div class="row mosque-committee-filters" style="margin-bottom:10px;">
                    <div class="col-sm-4">
                        <div class="form-group" style="margin-bottom:0;">
                            <label style="font-weight:600;">Status</label>
                            <select id="mc_status" class="form-control">
                                <option value="active">Active</option>
                                <option value="archived">Archived</option>
                                <option value="all">All</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group" style="margin-bottom:0;">
                            <label style="font-weight:600;">Term date range</label>
                            <input type="text" id="mc_term_range" class="form-control" value="{{ now()->startOfYear()->format('m/d/Y') }} - {{ now()->endOfYear()->format('m/d/Y') }}" placeholder="@lang('lang_v1.select_a_date_range')">
                            <p class="help-block" style="margin:4px 0 0;">Filter by term start/end.</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.committee.committees.create') }}" data-container=".mosque_committee_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_committees_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Term Start</th>
                                <th>Term End</th>
                                <th>Members</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_members">
                <div class="row mosque-committee-filters" style="margin-bottom:10px;">
                    <div class="col-sm-4">
                        <div class="form-group" style="margin-bottom:0;">
                            <label style="font-weight:600;">Committee</label>
                            {!! Form::select('mcm_committee_id', $committees ?? [], null, ['class' => 'form-control', 'id' => 'mcm_committee_id', 'placeholder' => __('lang_v1.all')]) !!}
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group" style="margin-bottom:0;">
                            <label style="font-weight:600;">Role</label>
                            {!! Form::select('mcm_role_id', $roles ?? [], null, ['class' => 'form-control', 'id' => 'mcm_role_id', 'placeholder' => __('lang_v1.all')]) !!}
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group" style="margin-bottom:0;">
                            <label style="font-weight:600;">WhatsApp</label>
                            <select id="mcm_has_whatsapp" class="form-control">
                                <option value="">@lang('lang_v1.all')</option>
                                <option value="yes">Has WhatsApp</option>
                                <option value="no">No WhatsApp</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.committee.members.create') }}" data-container=".mosque_committee_member_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_committee_members_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Photo</th>
                                <th>Committee</th>
                                <th>Name</th>
                                <th>Role</th>
                                <th>@lang('contact.mobile')</th>
                                <th>WhatsApp</th>
                                <th>@lang('business.email')</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_roles">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.committee.roles.create') }}" data-container=".mosque_committee_role_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_committee_roles_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>@lang('mosque::mosque.committee_role')</th>
                                <th>@lang('mosque::mosque.committee_sort_order')</th>
                                <th>@lang('lang_v1.status')</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_minutes">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.committee.minutes.create') }}" data-container=".mosque_minute_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_minutes_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Committee</th>
                                <th>Minute No</th>
                                <th>Date</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_reports">
                <div class="row mosque-committee-filters">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Committee</label>
                            {!! Form::select('committee_id', $committees ?? [], null, ['class' => 'form-control', 'id' => 'mcr_committee_id', 'placeholder' => __('lang_v1.all')]) !!}
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Date range</label>
                            <input type="text" id="mcr_date_range" class="form-control" value="{{ now()->startOfYear()->format('m/d/Y') }} - {{ now()->endOfYear()->format('m/d/Y') }}">
                            <input type="hidden" id="mcr_start_date" value="{{ now()->startOfYear()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <input type="hidden" id="mcr_end_date" value="{{ now()->endOfYear()->format('Y-m-d') }}">
                            <p class="help-block">Used on Minutes Archive.</p>
                        </div>
                    </div>
                </div>

                <ul class="nav nav-pills" style="margin-bottom:10px;">
                    <li class="active"><a href="#tab_reports_committees" data-toggle="tab">Term Summary</a></li>
                    <li><a href="#tab_reports_roles" data-toggle="tab">Role Distribution</a></li>
                    <li><a href="#tab_reports_minutes" data-toggle="tab">Minutes Archive</a></li>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_reports_committees">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_committee_term_report_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Committee</th>
                                        <th>Term Start</th>
                                        <th>Term End</th>
                                        <th>Members</th>
                                        <th>Minutes</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane" id="tab_reports_roles">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_committee_roles_report_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Committee</th>
                                        <th>Role</th>
                                        <th>Members</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane" id="tab_reports_minutes">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_committee_minutes_report_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Committee</th>
                                        <th>Year</th>
                                        <th>Minutes</th>
                                        <th>Last Meeting</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endcomponent

    <div class="modal fade mosque_committee_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_committee_member_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_committee_role_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_minute_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var committees_table = $('#mosque_committees_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.committee.committees.data") }}',
                data: function (d) {
                    d.status = $('#mc_status').val();
                    d.term_range = $('#mc_term_range').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'term_start', name: 'term_start' },
                { data: 'term_end', name: 'term_end' },
                { data: 'members_count', name: 'members_count', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        var members_table = $('#mosque_committee_members_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.committee.members.data") }}',
                data: function (d) {
                    d.committee_id = $('#mcm_committee_id').val();
                    d.role_id = $('#mcm_role_id').val();
                    d.has_whatsapp = $('#mcm_has_whatsapp').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'photo', name: 'photo', orderable: false, searchable: false },
                { data: 'committee', name: 'committee', orderable: false, searchable: false },
                { data: 'member_name', name: 'member_name' },
                { data: 'role_title', name: 'role_title' },
                { data: 'phone', name: 'phone' },
                { data: 'whatsapp_number', name: 'whatsapp_number', orderable: false, searchable: false },
                { data: 'email', name: 'email' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        var minutes_table = $('#mosque_minutes_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.committee.minutes.data") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'committee', name: 'committee', orderable: false, searchable: false },
                { data: 'minute_no', name: 'minute_no' },
                { data: 'date', name: 'date' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        function getCommitteeReportFilters() {
            return {
                committee_id: $('#mcr_committee_id').val(),
                start_date: $('#mcr_start_date').val(),
                end_date: $('#mcr_end_date').val(),
            };
        }

        var committee_term_report_table = $('#mosque_committee_term_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.committee.reports.committees") }}',
                data: function (d) { return $.extend({}, d, getCommitteeReportFilters()); }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'term_start', name: 'term_start' },
                { data: 'term_end', name: 'term_end' },
                { data: 'members_count', name: 'members_count', searchable: false },
                { data: 'minutes_count', name: 'minutes_count', searchable: false },
            ]
        });

        var committee_roles_report_table = $('#mosque_committee_roles_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.committee.reports.roles") }}',
                data: function (d) { return $.extend({}, d, getCommitteeReportFilters()); }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'committee_name', name: 'committee_name' },
                { data: 'role_title', name: 'role_title' },
                { data: 'members_count', name: 'members_count', searchable: false },
            ]
        });

        var committee_minutes_report_table = $('#mosque_committee_minutes_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.committee.reports.minutes") }}',
                data: function (d) { return $.extend({}, d, getCommitteeReportFilters()); }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'committee_name', name: 'committee_name' },
                { data: 'year', name: 'year' },
                { data: 'minutes_count', name: 'minutes_count', searchable: false },
                { data: 'last_meeting_date', name: 'last_meeting_date', searchable: false },
            ]
        });

        var roles_table = $('#mosque_committee_roles_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.committee.roles.data") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'sort_order', name: 'sort_order' },
                { data: 'is_active', name: 'is_active', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        function ajaxForm(selector, modalSelector, reloadTables) {
            $(document).on('submit', selector, function (e) {
                e.preventDefault();
                var $form = $(this);
                var formData = new FormData(this);
                $.ajax({
                    // Always POST multipart forms; Laravel will honor `_method` for PUT/PATCH/DELETE.
                    method: 'POST',
                    url: $form.attr('action'),
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (result) {
                        if (result.success) {
                            $(modalSelector).modal('hide');
                            toastr.success(result.msg);
                            reloadTables.forEach(function (t) { t.ajax.reload(); });
                        } else {
                            toastr.error(result.msg);
                        }
                    },
                    error: function (xhr) {
                        if (xhr && xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                            var first = null;
                            Object.keys(xhr.responseJSON.errors).some(function (k) {
                                if (xhr.responseJSON.errors[k] && xhr.responseJSON.errors[k][0]) {
                                    first = xhr.responseJSON.errors[k][0];
                                    return true;
                                }
                                return false;
                            });
                            if (first) {
                                toastr.error(first);
                                return;
                            }
                        }
                        toastr.error('@lang("messages.something_went_wrong")');
                    }
                });
            });
        }

        ajaxForm('form#mosque_committee_form', '.mosque_committee_modal', [committees_table]);
        ajaxForm('form#mosque_committee_member_form', '.mosque_committee_member_modal', [members_table, committees_table]);
        ajaxForm('form#mosque_committee_role_form', '.mosque_committee_role_modal', [roles_table]);
        ajaxForm('form#mosque_minute_form', '.mosque_minute_modal', [minutes_table]);

        // Delete handling is centralized (typed CONFIRM modal) for all `.delete_mosque_*` buttons.

        function parseRangeToHidden($input, $start, $end) {
            var v = ($input.val() || '').toString();
            if (!v || v.indexOf('-') === -1) return;
            var parts = v.split('-');
            if (parts.length < 2) return;
            var s = parts[0].trim();
            var e = parts[1].trim();
            if (s && e && window.moment) {
                $start.val(moment(s, 'MM/DD/YYYY').format('YYYY-MM-DD'));
                $end.val(moment(e, 'MM/DD/YYYY').format('YYYY-MM-DD'));
            }
        }

        if ($.fn.daterangepicker) {
            $('#mc_term_range').daterangepicker({
                startDate: moment().startOf('year'),
                endDate: moment().endOf('year'),
                autoUpdateInput: true,
                locale: { format: 'MM/DD/YYYY', cancelLabel: 'Clear' }
            }, function () {
                committees_table.ajax.reload();
            });
            $('#mc_term_range').on('cancel.daterangepicker', function () {
                $(this).val('');
                committees_table.ajax.reload();
            });

            $('#mcr_date_range').daterangepicker({
                startDate: moment($('#mcr_start_date').val()),
                endDate: moment($('#mcr_end_date').val()),
                locale: { format: 'MM/DD/YYYY' }
            }, function () {
                parseRangeToHidden($('#mcr_date_range'), $('#mcr_start_date'), $('#mcr_end_date'));
                committee_term_report_table.ajax.reload();
                committee_roles_report_table.ajax.reload();
                committee_minutes_report_table.ajax.reload();
            });
        }

        $(document).on('change', '#mc_status', function () {
            committees_table.ajax.reload();
        });
        $(document).on('change', '#mcm_committee_id, #mcm_role_id, #mcm_has_whatsapp', function () {
            members_table.ajax.reload();
        });

        $(document).on('change', '#mcr_committee_id, #mcr_start_date, #mcr_end_date', function () {
            committee_term_report_table.ajax.reload();
            committee_roles_report_table.ajax.reload();
            committee_minutes_report_table.ajax.reload();
        });

        $(document).on('click', '.restore_mosque_committee', function (e) {
            e.preventDefault();
            var url = $(this).data('href');
            $.ajax({
                method: 'POST',
                url: url,
                data: { _token: $('meta[name="csrf-token"]').attr('content') },
                success: function (result) {
                    if (result.success) {
                        toastr.success(result.msg);
                        committees_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                    error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                    }
                });
        });

        // Fix datatable sizing when switching tabs
        $('a[data-toggle="tab"]').on('shown.bs.tab', function () {
            try {
                $.fn.dataTable.tables({ visible: true, api: true }).columns.adjust();
            } catch (e) {}
        });
    });
</script>
@endsection
