<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Committee Invitation - {{ $committee->name }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { display:flex; justify-content: flex-end; gap: 8px; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; display:flex; justify-content: space-between; gap: 12px; align-items: center; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid th, .grid td { border: 1px solid #ddd; padding: 8px 6px; text-align:left; font-size: 12px; }
        .grid th { background: #f5f5f5; }
        .box { border: 1px solid #ddd; padding: 10px; border-radius: 4px; margin-top: 12px; font-size: 12px; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    <div class="no-print">
        <a class="btn btn-default" href="{{ route('mosque.committee') }}" style="text-decoration:none;">Back</a>
        <a href="{{ route('mosque.committee.invite.pdf', [$committee->id]) }}" style="text-decoration:none;">Download PDF</a>

        @php
            $waMembers = $members->filter(function ($m) {
                return !empty($m->whatsapp_number) || !empty($m->phone);
            });
        @endphp
        @if($waMembers->isNotEmpty())
            <select id="mosque_committee_whatsapp_member" style="padding:5px 8px; min-width: 240px;">
                @foreach($waMembers as $m)
                    <option value="{{ route('mosque.committee.invite.whatsapp', [$committee->id, $m->id]) }}">
                        {{ $m->member_name }}{{ !empty($m->role_title) ? (' - '.$m->role_title) : '' }}
                    </option>
                @endforeach
            </select>
            <button type="button" id="mosque_committee_whatsapp_invite_btn" title="Open WhatsApp with invitation message">
                <span style="display:inline-flex;align-items:center;gap:6px;"><i class="fa fa-whatsapp"></i> Invite</span>
            </button>
        @endif

        <form method="post" action="{{ route('mosque.committee.invite.email', [$committee->id]) }}" style="display:inline;">
            {{ csrf_field() }}
            <button type="submit">Send Email To All</button>
        </form>
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @if(session('status'))
        <div class="box" style="border-color:#e5e7eb;">
            <strong>{{ session('status.success') ? 'Success' : 'Error' }}:</strong>
            {{ session('status.msg') ?? '' }}
        </div>
    @endif

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;
        $logoUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try {
                $logoUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo);
            } catch (\Exception $e) { $logoUrl = null; }
        }
        $termStart = !empty($committee->term_start) ? \Carbon\Carbon::parse($committee->term_start)->format('Y-m-d') : '';
        $termEnd = !empty($committee->term_end) ? \Carbon\Carbon::parse($committee->term_end)->format('Y-m-d') : '';
        $template = (string) ($settings['template_email_message'] ?? '');
        if (trim($template) === '') {
            $template = "Assalamu Alaikum,\n\nYou are invited to join the committee: {committee}\nTerm: {term_start} to {term_end}\n\nRegards,\n{mosque}";
        }
        $preview = strtr($template, [
            '{business}' => $businessName,
            '{mosque}' => $headerName,
            '{committee}' => (string) $committee->name,
            '{term_start}' => (string) $termStart,
            '{term_end}' => (string) $termEnd,
            '{member}' => 'Member Name',
            '{role}' => 'Role',
            '{date}' => now()->format('Y-m-d'),
        ]);
    @endphp

    <div class="header">
        <div>
            <h1>Executive Committee Invitation</h1>
            <div class="muted">
                {{ $headerName }} &nbsp;|&nbsp; Committee: {{ $committee->name }}
                @if(!empty($termStart) || !empty($termEnd))
                    &nbsp;|&nbsp; Term: {{ $termStart }} {{ !empty($termEnd) ? ('to '.$termEnd) : '' }}
                @endif
            </div>
        </div>
        @if(!empty($logoDataUri) || !empty($logoUrl))
            <div><img src="{{ $logoDataUri ?? $logoUrl }}" alt="Logo" style="max-height:60px;"></div>
        @endif
    </div>

    @if(!empty($profile) && (!empty($profile->address) || !empty($profile->reg_no)))
        <div class="muted">
            {{ $profile->address ?? '' }}
            @if(!empty($profile->reg_no))
                &nbsp;|&nbsp; Reg: {{ $profile->reg_no }}
            @endif
        </div>
    @endif

    @if(!empty($profile) && !empty($profile->header_text))
        <div class="box">{!! nl2br(e($profile->header_text)) !!}</div>
    @endif

    <div class="box">
        <strong>Invitation Message (Template Preview)</strong><br>
        {!! nl2br(e($preview)) !!}
        <div class="muted" style="margin-top:6px;">
            Available tokens: {member}, {role}, {committee}, {term_start}, {term_end}, {mosque}, {business}, {date}
        </div>
    </div>

    <h3 style="margin-top:16px;">Members</h3>
    <table class="grid">
        <thead>
            <tr>
                <th>Name</th>
                <th>Role</th>
                <th>Phone</th>
                <th>Email</th>
                <th>WhatsApp</th>
            </tr>
        </thead>
        <tbody>
            @forelse($members as $m)
                <tr>
                    <td>{{ $m->member_name }}</td>
                    <td>{{ $m->role_title ?? '' }}</td>
                    <td>{{ $m->phone ?? '' }}</td>
                    <td>{{ $m->email ?? '' }}</td>
                    <td>
                        @if(!empty($m->whatsapp_number) || !empty($m->phone))
                            <a href="{{ route('mosque.committee.invite.whatsapp', [$committee->id, $m->id]) }}" title="Send WhatsApp invite" style="text-decoration:none;">
                                <span style="display:inline-flex;align-items:center;gap:6px;">
                                    <i class="fa fa-whatsapp"></i> Invite
                                </span>
                            </a>
                        @endif
                    </td>
                </tr>
            @empty
                <tr><td colspan="5" class="muted">No members added yet.</td></tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>

<script>
    (function () {
        var btn = document.getElementById('mosque_committee_whatsapp_invite_btn');
        var sel = document.getElementById('mosque_committee_whatsapp_member');
        if (!btn || !sel) return;
        btn.addEventListener('click', function () {
            var url = sel.value;
            if (!url) return;
            window.open(url, '_blank', 'noopener');
        });
    })();
</script>
