<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@lang('mosque::mosque.committee_id_card') - {{ $member->member_name }}</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 18px; color: #0f172a; }
        .no-print { text-align: right; margin-bottom: 10px; }
        .sheet { display:flex; justify-content:center; }
        .card {
            width: 340px;
            border-radius: 14px;
            border: 1px solid rgba(15,23,42,.12);
            overflow: hidden;
            box-shadow: 0 10px 22px rgba(2,6,23,.12);
            background: #fff;
        }
        .card-top {
            background: linear-gradient(135deg,#0ea5a0,#2563eb);
            color:#fff;
            padding: 12px 14px;
        }
        .title { font-size: 14px; font-weight: 800; margin: 0; }
        .sub { font-size: 11px; opacity: .95; margin-top: 2px; }
        .card-body { padding: 12px 14px; }
        .row { display:flex; gap: 12px; }
        .photo { width: 86px; height: 96px; border-radius: 10px; border: 1px solid rgba(15,23,42,.12); object-fit: cover; background: #f8fafc; }
        .kv { flex: 1; }
        .kv .name { font-size: 14px; font-weight: 800; margin: 0; }
        .kv .role { font-size: 12px; font-weight: 700; margin: 2px 0 0 0; color:#0f172a; }
        .kv .meta { font-size: 11px; color:#475569; margin-top: 6px; line-height: 1.35; }
        .grid { margin-top: 10px; display:grid; grid-template-columns: 1fr 1fr; gap: 8px 10px; }
        .field { font-size: 11px; }
        .field .k { color:#64748b; font-weight:700; display:block; }
        .field .v { color:#0f172a; font-weight:700; }
        .bottom { margin-top: 10px; display:flex; justify-content:space-between; gap: 10px; align-items:flex-end; }
        .qr { width: 86px; height: 86px; border:1px solid rgba(15,23,42,.12); border-radius: 10px; padding: 6px; background: #fff; }
        .sig { flex: 1; text-align: right; font-size: 10px; color:#64748b; }
        .sig img { max-height: 34px; max-width: 140px; display:block; margin-left:auto; }
        .sig .line { border-top: 1px solid rgba(15,23,42,.25); margin-top: 6px; padding-top: 3px; font-weight: 800; color:#0f172a; }
        @media print {
            .no-print { display:none !important; }
            body { margin: 0; }
            .card { box-shadow:none; }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">@lang('messages.print')</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? (string) $profile->name : $businessName;
        $mosqueAddress = !empty($profile) && !empty($profile->address) ? (string) $profile->address : '';
        $committeeName = (string) ($committee?->name ?? '');
        $termStart = !empty($committee?->term_start) ? \Carbon\Carbon::parse($committee->term_start)->format('Y-m-d') : '';
        $termEnd = !empty($committee?->term_end) ? \Carbon\Carbon::parse($committee->term_end)->format('Y-m-d') : '';
        $term = trim($termStart.($termEnd !== '' ? ' to '.$termEnd : ''));
        $role = trim((string) ($member->role_title ?? ''));
        $cardNo = trim((string) ($member->card_no ?? ''));
        $docType = (string) ($member->id_doc_type ?? '');
        $docTypeLabel = $docType === 'nid' ? __('mosque::mosque.committee_id_doc_nid') : ($docType === 'passport' ? __('mosque::mosque.committee_id_doc_passport') : __('mosque::mosque.committee_id_doc_other'));
        $docNo = trim((string) ($member->id_doc_no ?? ''));
        $issuedOn = now()->format('Y-m-d');
        $qrText = 'MOSQUE_COMMITTEE_MEMBER|'.$businessName.'|'.$businessName.'|'.$member->id.'|'.$cardNo;
        try {
            $qrBase64 = DNS2D::getBarcodePNG($qrText, 'QRCODE', 4, 4);
        } catch (\Throwable $e) {
            $qrBase64 = '';
        }
        $authName2 = trim((string) ($authName ?? ''));
        $authTitle2 = trim((string) ($authTitle ?? ''));
    @endphp

    <div class="sheet">
        <div class="card">
            <div class="card-top">
                <div style="display:flex; align-items:center; justify-content:space-between; gap:10px;">
                    <div>
                        <p class="title" style="margin:0;">{{ $headerName }}</p>
                        <div class="sub">
                            @lang('mosque::mosque.menu_committee')@if($committeeName !== ''): {{ $committeeName }}@endif
                        </div>
                    </div>
                    @if(!empty($logoDataUri))
                        <img src="{{ $logoDataUri }}" alt="Logo" style="max-height:34px; max-width:80px; background:#fff; padding:4px; border-radius:8px;">
                    @endif
                </div>
            </div>

            <div class="card-body">
                <div class="row">
                    <img class="photo" src="{{ $photoUrl }}" alt="Photo">
                    <div class="kv">
                        <p class="name">{{ $member->member_name }}</p>
                        @if($role !== '')
                            <p class="role">{{ $role }}</p>
                        @endif
                        <div class="meta">
                            @if($mosqueAddress !== ''){!! nl2br(e($mosqueAddress)) !!}@endif
                        </div>
                    </div>
                </div>

                <div class="grid">
                    <div class="field">
                        <span class="k">@lang('mosque::mosque.committee_card_no')</span>
                        <span class="v">{{ $cardNo !== '' ? $cardNo : ('CM-'.$member->id) }}</span>
                    </div>
                    <div class="field">
                        <span class="k">@lang('lang_v1.date')</span>
                        <span class="v">{{ $issuedOn }}</span>
                    </div>
                    <div class="field" style="grid-column: 1 / span 2;">
                        <span class="k">@lang('mosque::mosque.committee_id_doc_type')</span>
                        <span class="v">{{ $docTypeLabel }} @if($docNo !== '') - {{ $docNo }}@endif</span>
                    </div>
                    @if($term !== '')
                        <div class="field" style="grid-column: 1 / span 2;">
                            <span class="k">Term</span>
                            <span class="v">{{ $term }}</span>
                        </div>
                    @endif
                </div>

                <div class="bottom">
                    <div class="qr">
                        @if($qrBase64 !== '')
                            <img src="data:image/png;base64,{{ $qrBase64 }}" alt="QR" style="width:100%; height:100%;">
                        @endif
                    </div>
                    <div class="sig">
                        @if(!empty($sigUrl))
                            <img src="{{ $sigUrl }}" alt="Signature">
                        @endif
                        <div class="line">
                            {{ $authName2 !== '' ? $authName2 : __('mosque::mosque.bank_authorised_signature') }}
                            @if($authTitle2 !== '') <span style="font-weight:700;color:#475569;">({{ $authTitle2 }})</span>@endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>

