<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.committee.members.store'), 'method' => 'post', 'id' => 'mosque_committee_member_form', 'files' => true]) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.add')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="well well-sm" style="margin-bottom:10px;">
                        <div class="row" style="display:flex; align-items:center; gap:12px;">
                            <div>
                                <img id="mosque_committee_member_photo_preview" style="width:90px;height:90px;border-radius:10px;border:1px solid #e6eef7;object-fit:cover;background:#fff;" src="{{ asset('img/default.png') }}" onerror="this.onerror=null;this.src='{{ asset('public/img/default.png') }}';" alt="Photo">
                            </div>
                            <div style="flex:1;">
                                <div class="form-group" style="margin-bottom:6px;">
                                    {!! Form::label('photo', __('mosque::mosque.committee_member_photo') . ':*') !!}
                                    <input type="file" name="photo" id="mosque_committee_member_photo_file" class="form-control" accept="image/*" required>
                                </div>
                                <div class="form-group" style="margin-bottom:0;">
                                    <button type="button" class="btn btn-default" id="mosque_committee_member_open_camera">
                                        <i class="fa fa-camera"></i> @lang('mosque::mosque.committee_use_camera')
                                    </button>
                                    {!! Form::hidden('photo_capture', null, ['id' => 'mosque_committee_member_photo_capture']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('committee_id', __('mosque::mosque.committee_committee') . ':*') !!}
                        {!! Form::select('committee_id', $committees, null, ['class' => 'form-control', 'required', 'placeholder' => __('lang_v1.please_select')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('role_id', __('mosque::mosque.committee_role') . ':') !!}
                        @if(!empty($roles))
                            {!! Form::select('role_id', $roles, null, ['class' => 'form-control', 'placeholder' => __('lang_v1.please_select')]) !!}
                            <small class="text-muted">@lang('mosque::mosque.committee_role_help')</small>
                        @else
                            {!! Form::text('role_title', null, ['class' => 'form-control']) !!}
                        @endif
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('id_doc_type', __('mosque::mosque.committee_id_doc_type') . ':*') !!}
                        <select name="id_doc_type" class="form-control" required>
                            <option value="">@lang('lang_v1.please_select')</option>
                            <option value="nid">@lang('mosque::mosque.committee_id_doc_nid')</option>
                            <option value="passport">@lang('mosque::mosque.committee_id_doc_passport')</option>
                            <option value="other">@lang('mosque::mosque.committee_id_doc_other')</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('id_doc_no', __('mosque::mosque.committee_id_doc_no') . ':*') !!}
                        {!! Form::text('id_doc_no', null, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('id_doc_file', __('mosque::mosque.committee_id_doc_file') . ':*') !!}
                        <input type="file" name="id_doc_file" class="form-control" accept="image/*,application/pdf" required>
                        <small class="text-muted">@lang('mosque::mosque.committee_id_doc_help')</small>
                    </div>
                </div>

                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('member_name', __('mosque::mosque.committee_member_name') . ':*') !!}
                        {!! Form::text('member_name', null, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('phone', __('contact.mobile') . ':') !!}
                        {!! Form::text('phone', null, ['class' => 'form-control', 'id' => 'mosque_committee_member_phone', 'placeholder' => __('contact.mobile')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('whatsapp_number', 'WhatsApp:') !!}
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-whatsapp"></i></span>
                            {!! Form::text('whatsapp_number', null, ['class' => 'form-control', 'id' => 'mosque_committee_member_whatsapp_number', 'placeholder' => __('contact.mobile')]) !!}
                        </div>
                        <div class="checkbox" style="margin-top:5px;">
                            <label style="margin:0;">
                                {!! Form::hidden('whatsapp_same_as_phone', 0) !!}
                                <input type="checkbox" id="mosque_committee_member_whatsapp_same" name="whatsapp_same_as_phone" value="1" checked>
                                Same as mobile
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('email', __('business.email') . ':') !!}
                        {!! Form::email('email', null, ['class' => 'form-control']) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script type="text/javascript">
    $(function () {
        function syncCommitteeMemberWhatsapp() {
            var same = $('#mosque_committee_member_whatsapp_same').is(':checked');
            $('#mosque_committee_member_whatsapp_number').prop('readonly', same);
            if (same) {
                $('#mosque_committee_member_whatsapp_number').val($('#mosque_committee_member_phone').val());
            }
        }
        $(document).on('change', '#mosque_committee_member_whatsapp_same', syncCommitteeMemberWhatsapp);
        $(document).on('keyup', '#mosque_committee_member_phone', function () {
            if ($('#mosque_committee_member_whatsapp_same').is(':checked')) {
                $('#mosque_committee_member_whatsapp_number').val($(this).val());
            }
        });
        $(document).ready(syncCommitteeMemberWhatsapp);

        // Photo preview (upload)
        $('#mosque_committee_member_photo_file').on('change', function (e) {
            var f = e.target.files && e.target.files[0];
            if (!f) return;
            var reader = new FileReader();
            reader.onload = function (ev) {
                $('#mosque_committee_member_photo_preview').attr('src', ev.target.result);
            };
            reader.readAsDataURL(f);
        });

        // Camera capture modal
        var stream = null;
        function stopStream() {
            if (stream) {
                stream.getTracks().forEach(function (t) { t.stop(); });
                stream = null;
            }
        }

        $(document).on('click', '#mosque_committee_member_open_camera', async function () {
            if (!window.isSecureContext) {
                toastr.error('Camera requires HTTPS (or localhost). Please open the app on https:// and try again.');
                return;
            }
            if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
                toastr.error('Camera is not supported in this browser.');
                return;
            }
            try {
                $('#mosque_committee_member_camera_modal').modal('show');
                stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: false });
                var v = document.getElementById('mosque_committee_member_camera_video');
                v.srcObject = stream;
                v.play();
            } catch (e) {
                var msg = 'Camera permission denied. Please allow camera access for this site.';
                if (e && e.name === 'NotFoundError') {
                    msg = 'No camera device found.';
                } else if (e && e.name === 'NotAllowedError') {
                    msg = 'Camera permission denied. Please allow camera access for this site.';
                } else if (e && e.name === 'NotReadableError') {
                    msg = 'Camera is busy or not readable. Close other apps using camera and try again.';
                }
                toastr.error(msg);
                stopStream();
                $('#mosque_committee_member_camera_modal').modal('hide');
            }
        });

        $(document).on('click', '#mosque_committee_member_camera_capture_btn', function () {
            var v = document.getElementById('mosque_committee_member_camera_video');
            var c = document.getElementById('mosque_committee_member_camera_canvas');
            var ctx = c.getContext('2d');
            c.width = v.videoWidth || 640;
            c.height = v.videoHeight || 480;
            ctx.drawImage(v, 0, 0, c.width, c.height);
            var dataUrl = c.toDataURL('image/jpeg', 0.9);
            $('#mosque_committee_member_photo_preview').attr('src', dataUrl);
            $('#mosque_committee_member_photo_capture').val(dataUrl);
            $('#mosque_committee_member_camera_modal').modal('hide');
            stopStream();
        });

        $('#mosque_committee_member_camera_modal').on('hidden.bs.modal', function () {
            stopStream();
        });
    });
</script>

<div class="modal fade" id="mosque_committee_member_camera_modal" tabindex="-1" role="dialog" aria-labelledby="mosqueCommitteeMemberCameraLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="mosqueCommitteeMemberCameraLabel">@lang('mosque::mosque.committee_capture_photo')</h4>
            </div>
            <div class="modal-body">
                <video id="mosque_committee_member_camera_video" style="width:100%; border-radius:8px; background:#000;" playsinline></video>
                <canvas id="mosque_committee_member_camera_canvas" style="display:none;"></canvas>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="mosque_committee_member_camera_capture_btn">@lang('mosque::mosque.committee_capture_photo')</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
            </div>
        </div>
    </div>
</div>
