<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Committee Minute - {{ $minute->id }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { display:flex; justify-content: flex-end; gap: 8px; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; display:flex; justify-content: space-between; gap: 12px; align-items: center; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid td { padding: 7px 6px; vertical-align: top; }
        .label { width: 180px; color: #333; font-weight: bold; }
        .box { border: 1px solid #ddd; padding: 10px; border-radius: 4px; margin-top: 12px; font-size: 12px; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;
        $logoFallbackUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try {
                $logoFallbackUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo);
            } catch (\Exception $e) { $logoFallbackUrl = null; }
        }
        $logoSrc = $logoDataUri ?? $logoFallbackUrl;
        $minuteNo = $minute->minute_no ?: ('MIN-'.$minute->id);
        $minuteDate = !empty($minute->date) ? \Carbon\Carbon::parse($minute->date)->format('Y-m-d') : '-';
        $committeeName = $committee?->name ?: '';
    @endphp

    <div class="header">
        <div>
            <h1>Meeting Minutes</h1>
            <div class="muted">{{ $headerName }} &nbsp;|&nbsp; {{ $committeeName }}</div>
        </div>
        @if(!empty($logoSrc))
            <div><img src="{{ $logoSrc }}" alt="Logo" style="max-height:60px;"></div>
        @endif
    </div>

    <table class="grid">
        <tr>
            <td class="label">Minute No</td>
            <td>{{ $minuteNo }}</td>
        </tr>
        <tr>
            <td class="label">Date</td>
            <td>{{ $minuteDate }}</td>
        </tr>
        <tr>
            <td class="label">Committee</td>
            <td>{{ $committeeName }}</td>
        </tr>
    </table>

    <div class="box">
        <strong>Decisions / Notes</strong><br>
        {!! nl2br(e($minute->decisions ?? '')) ?: '-' !!}
    </div>

    @if(!empty($profile) && !empty($profile->header_text))
        <div class="box">
            {!! nl2br(e($profile->header_text)) !!}
        </div>
    @endif
</body>
</html>

