<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.committee.roles.update', $role->id), 'method' => 'post', 'id' => 'mosque_committee_role_form']) !!}
        {!! Form::hidden('_method', 'PUT') !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.edit')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('name', __('mosque::mosque.committee_role_name') . ':*') !!}
                        {!! Form::text('name', $role->name, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        {!! Form::label('sort_order', __('mosque::mosque.committee_sort_order') . ':') !!}
                        {!! Form::number('sort_order', (int) ($role->sort_order ?? 0), ['class' => 'form-control', 'min' => 0]) !!}
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group" style="margin-top:25px;">
                        <label>
                            {!! Form::checkbox('is_active', 1, !empty($role->is_active)) !!}
                            @lang('lang_v1.active')
                        </label>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('lang_v1.note') . ':') !!}
                        {!! Form::textarea('notes', $role->notes, ['class' => 'form-control', 'rows' => 2, 'placeholder' => __('lang_v1.note')]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

