@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_dashboard'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black" style="display:flex;justify-content:space-between;align-items:center;gap:12px;">
        <span>@lang('mosque::mosque.menu_dashboard')</span>
        <span style="min-width:280px;">
            <input type="text" id="mosque_dashboard_date_range" class="form-control" readonly
                placeholder="@lang('lang_v1.select_a_date_range')"
                value="{{ !empty($dateRange) ? ($dateRange['start'].' ~ '.$dateRange['end']) : '' }}">
        </span>
    </h1>
</section>

<section class="content">
    <style>
        /* Default stat cards: white, so highlighted groups are visually different */
        .mosque-stat-card .box-body {
            padding: 14px 16px;
            border-radius: 10px;
            background: #f8fafc !important;
            box-shadow: 0 10px 18px rgba(0,0,0,.08);
        }
        /* Highlighted cards (match dashboard widget green area) */
        .mosque-stat-card--blend .box-body {
            background: #dff5ea !important;
            border: 1px solid rgba(15, 23, 42, 0.10);
            box-shadow: 0 8px 14px rgba(0,0,0,.06);
        }
        .mosque-stat-card--blend .mosque-stat-title { color: #0f3d2e; }
        .mosque-stat-title { font-weight: 700; color: #244; font-size: 13px; }
        .mosque-stat-title i { margin-right: 6px; opacity: .9; }
        .mosque-stat-value { font-size: 22px; font-weight: 800; margin-top: 2px; }
        .mosque-subtle { color: #6b7280; font-size: 12px; }
        .mosque-table-card .box-body { border-radius: 10px; box-shadow: 0 10px 18px rgba(0,0,0,.08); }
        .mosque-kv { width: 100%; border-collapse: collapse; }
        .mosque-kv td { padding: 7px 8px; border-bottom: 1px solid #eef2f7; }
        .mosque-kv tr:last-child td { border-bottom: none; }
        .mosque-k { color: #334155; font-weight: 700; }
        .mosque-v { text-align: right; white-space: nowrap; }
        .mosque-breakdown-amount { font-weight: 800; color: #0f172a; }
        .mosque-header-text { font-weight: 800; font-size: 14px; color: #111827; }
        .mosque-profile-name { font-weight: 800; font-size: 22px; color: #0f172a; margin: 0; }

        .mosque-breakdown-card { border-radius: 10px; padding: 14px; border: 1px solid rgba(15, 23, 42, 0.08); background: #f8fafc; }
        .mosque-breakdown-title { font-weight: 800; font-size: 15px; margin: 0 0 8px 0; }
        .mosque-breakdown-title-income { color: #1d4ed8; }
        .mosque-breakdown-title-expense { color: #c2410c; }
        .mosque-breakdown-subtitle { font-weight: 700; font-size: 13px; margin: 0 0 8px 0; color: #334155; }
        .mosque-breakdown-subtitle-income { color: #1e40af; }
        .mosque-breakdown-subtitle-expense { color: #9a3412; }
        .mosque-breakdown-title i, .mosque-breakdown-subtitle i { margin-right: 6px; opacity: .9; }

        #mosque-clock { text-align:center; padding: 4px 0; }
        #mc-time {
            font-weight: 800;
            font-size: 2.05rem;
            letter-spacing: 0.02em;
            font-variant-numeric: tabular-nums;
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            color: #0f172a;
            line-height: 1.15;
        }
        #mc-en, #mc-ar, #mc-bn { font-size: 1.05rem; opacity: 0.9; margin-top: 2px; line-height: 1.3; }
        #mc-ar { direction: ltr; unicode-bidi: plaintext; }
        .mc-season { margin-top: 2px; font-size: 1.0rem; opacity: 0.85; }
        .mc-sep { display: none; }
        #mc-time { display: inline-block; padding-bottom: 6px; border-bottom: 4px solid #111; }
        @media (max-width: 767px) { #mosque-clock { margin-top: 10px; margin-bottom: 6px; } }
    </style>

    @php
        $logoVersion = !empty($profile) && !empty($profile->updated_at)
            ? (string) $profile->updated_at->timestamp
            : (string) time();
        $logoUrl = !empty($profile) && !empty($profile->logo)
            ? route('mosque.logo', ['filename' => (string) $profile->logo]).'?v='.$logoVersion
            : null;
    @endphp

    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-5">
                <h3 class="mosque-profile-name">
                    {{ $profile->name ?? (request()->session()->get('business.name') ?: __('mosque::mosque.mosque')) }}
                </h3>
                @if(!empty($settings) && !empty($settings['hijri_display_enabled']) && !empty($hijriDate))
                    <p class="text-muted" style="margin-bottom:6px;">
                        <strong>Hijri:</strong> {{ $hijriDate }}
                    </p>
                @endif
                @if(!empty($settings) && !empty($settings['prayer_calc_preference']))
                    <p class="text-muted" style="margin-bottom:6px;">
                        <strong>Prayer:</strong> {{ ucfirst(str_replace('_', ' ', (string) $settings['prayer_calc_preference'])) }}
                        @if((string) $settings['prayer_calc_preference'] === 'manual' && !empty($settings['prayer_calc_manual_note']))
                            <br><small>{{ $settings['prayer_calc_manual_note'] }}</small>
                        @endif
                    </p>
                @endif
                @if(!empty($profile) && (!empty($profile->address) || !empty($profile->reg_no)))
                    <p class="text-muted" style="margin-bottom:0;">
                        {{ $profile->address ?? '' }}
                        @if(!empty($profile->reg_no))
                            <br>Reg: {{ $profile->reg_no }}
                        @endif
                    </p>
                @endif
            </div>
            <div class="col-sm-3">
                <div id="mosque-clock" data-tz="{{ $timezone ?? config('app.timezone') }}">
                    <div id="mc-time" aria-live="polite"></div>
                    <div class="mc-sep"></div>
                    <div id="mc-en"></div>
                    <div id="mc-ar"></div>
                    <div id="mc-bn"></div>
                </div>
            </div>
                <div class="col-sm-4 text-right">
                    @if(!empty($logoUrl))
                        <img src="{{ $logoUrl }}" alt="Logo" style="max-height:130px; max-width:300px; object-fit:contain;">
                    @endif
                </div>
            </div>
        @if(!empty($profile) && !empty($profile->header_text))
            <hr>
            <p class="mosque-header-text">{!! nl2br(e($profile->header_text)) !!}</p>
        @endif
    @endcomponent

    <div class="row">
        <div class="col-sm-3">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                <div class="mosque-stat-title"><i class="fa fa-users"></i> Total Members</div>
                <div class="mosque-stat-value">{{ (int) ($counts['members_total'] ?? 0) }}</div>
                <div class="mosque-subtle">All time</div>
            @endcomponent
        </div>
        <div class="col-sm-3">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                <div class="mosque-stat-title"><i class="fa fa-user"></i> Active Members</div>
                <div class="mosque-stat-value">{{ (int) ($counts['members_active'] ?? 0) }}</div>
                <div class="mosque-subtle">All time</div>
            @endcomponent
        </div>
        <div class="col-sm-3">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                <div class="mosque-stat-title"><i class="fa fa-heart"></i> Donations (Selected)</div>
                <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($counts['donations_month'] ?? 0) }}">{{ (float) ($counts['donations_month'] ?? 0) }}</div>
                <div class="mosque-subtle">{{ $dateRange['start'] ?? '' }} to {{ $dateRange['end'] ?? '' }}</div>
            @endcomponent
        </div>
        <div class="col-sm-3">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                <div class="mosque-stat-title"><i class="fa fa-id-card"></i> Membership Fees (Selected)</div>
                <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($counts['membership_month'] ?? 0) }}">{{ (float) ($counts['membership_month'] ?? 0) }}</div>
                <div class="mosque-subtle">{{ $dateRange['start'] ?? '' }} to {{ $dateRange['end'] ?? '' }}</div>
            @endcomponent
        </div>
    </div>

    <div class="row">
        <div class="col-sm-4">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card'])
                <div class="mosque-stat-title"><i class="fa fa-arrow-up"></i> Total Income (Selected)</div>
                <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($finance['income_total'] ?? 0) }}">{{ (float) ($finance['income_total'] ?? 0) }}</div>
                <div class="mosque-subtle">Module + POS Sales (Received)</div>
            @endcomponent
        </div>
        <div class="col-sm-4">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card'])
                <div class="mosque-stat-title"><i class="fa fa-arrow-down"></i> Total Expense (Selected)</div>
                <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($finance['expense_total'] ?? 0) }}">{{ (float) ($finance['expense_total'] ?? 0) }}</div>
                <div class="mosque-subtle">Module + POS Purchases (Paid)</div>
            @endcomponent
        </div>
        <div class="col-sm-4">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card'])
                <div class="mosque-stat-title"><i class="fa fa-balance-scale"></i> Net movement (Selected)</div>
                <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($finance['net_total'] ?? 0) }}">{{ (float) ($finance['net_total'] ?? 0) }}</div>
                <div class="mosque-subtle">Income − Expense</div>
            @endcomponent
        </div>
    </div>

        <div class="row">
            <div class="col-sm-4">
                @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                <div class="mosque-stat-title"><i class="fa fa-money"></i> @lang('mosque::mosque.bank_cash_balance')</div>
                <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($bankSummary['cash_net_balance'] ?? 0) }}">{{ (float) ($bankSummary['cash_net_balance'] ?? 0) }}</div>
                <div class="mosque-subtle">@lang('mosque::mosque.bank_cash_balance_help') @if(!empty($dateRange['end']))<span style="white-space:nowrap;">(as of {{ $dateRange['end'] }})</span>@endif</div>
            @endcomponent
        </div>
        <div class="col-sm-4">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                <div class="mosque-stat-title"><i class="fa fa-university"></i> @lang('mosque::mosque.bank_total_bank_wallets')</div>
                <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($bankSummary['bank_wallet_total'] ?? 0) }}">{{ (float) ($bankSummary['bank_wallet_total'] ?? 0) }}</div>
                <div class="mosque-subtle">@lang('mosque::mosque.bank_total_bank_wallets_help') @if(!empty($dateRange['end']))<span style="white-space:nowrap;">(as of {{ $dateRange['end'] }})</span>@endif</div>
            @endcomponent
        </div>
        <div class="col-sm-4">
            @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                <div class="mosque-stat-title"><i class="fa fa-line-chart"></i> @lang('mosque::mosque.bank_net_including_bank')</div>
                <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($bankSummary['net_including_bank'] ?? 0) }}">{{ (float) ($bankSummary['net_including_bank'] ?? 0) }}</div>
                <div class="mosque-subtle">@lang('mosque::mosque.bank_net_including_bank_help') @if(!empty($dateRange['end']))<span style="white-space:nowrap;">(as of {{ $dateRange['end'] }})</span>@endif</div>
            @endcomponent
        </div>
    </div>

    @if(!empty($includeCorePos))
        <div class="row">
            <div class="col-sm-6">
                @component('components.widget', ['class' => 'box-primary mosque-stat-card'])
                    <div class="mosque-stat-title"><i class="fa fa-clock-o"></i> POS Sales Due (Selected)</div>
                    <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($finance['core_sales_due'] ?? 0) }}">{{ (float) ($finance['core_sales_due'] ?? 0) }}</div>
                    <div class="mosque-subtle">Outstanding from customers</div>
                @endcomponent
            </div>
            <div class="col-sm-6">
                @component('components.widget', ['class' => 'box-primary mosque-stat-card'])
                    <div class="mosque-stat-title"><i class="fa fa-clock-o"></i> POS Purchases Due (Selected)</div>
                    <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($finance['core_purchases_due'] ?? 0) }}">{{ (float) ($finance['core_purchases_due'] ?? 0) }}</div>
                    <div class="mosque-subtle">Outstanding to suppliers</div>
                @endcomponent
            </div>
        </div>
    @endif

    @component('components.widget', ['class' => 'box-primary mosque-table-card'])
        <div class="row">
            <div class="col-sm-6">
                <div class="mosque-breakdown-card">
                    <h4 class="mosque-breakdown-title mosque-breakdown-title-income"><i class="fa fa-line-chart"></i> Income Breakdown (Selected)</h4>
                    <table class="mosque-kv">
                        @foreach(($financeBreakdown['income_sources'] ?? []) as $row)
                            <tr>
                                <td class="mosque-k">
                                    @php($label = (string) ($row['name'] ?? ''))
                                    @if(stripos($label, 'pos sales') !== false)
                                        @if(stripos($label, 'due') !== false)
                                            <i class="fa fa-clock-o"></i>
                                        @else
                                            <i class="fa fa-shopping-cart"></i>
                                        @endif
                                    @elseif(stripos($label, 'module finance') !== false)
                                        <i class="fa fa-book"></i>
                                    @else
                                        <i class="fa fa-circle-o"></i>
                                    @endif
                                    {{ $label }}
                                </td>
                                <td class="mosque-v">
                                    <span class="display_currency mosque-breakdown-amount" data-currency_symbol="true" data-orig-value="{{ (float) ($row['total'] ?? 0) }}">{{ (float) ($row['total'] ?? 0) }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </table>
                    <hr style="margin:12px 0;">
                    <h5 class="mosque-breakdown-subtitle mosque-breakdown-subtitle-income"><i class="fa fa-tags"></i> By Category (Module)</h5>
                    <table class="mosque-kv">
                        @foreach(($financeBreakdown['income_categories'] ?? []) as $row)
                            <tr>
                                <td class="mosque-k">{{ $row['name'] }}</td>
                                <td class="mosque-v">
                                    <span class="display_currency mosque-breakdown-amount" data-currency_symbol="true" data-orig-value="{{ (float) ($row['total'] ?? 0) }}">{{ (float) ($row['total'] ?? 0) }}</span>
                                </td>
                            </tr>
                        @endforeach
                        @if(empty($financeBreakdown['income_categories']))
                            <tr><td class="mosque-k">No categories</td><td class="mosque-v">0</td></tr>
                        @endif
                    </table>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="mosque-breakdown-card">
                    <h4 class="mosque-breakdown-title mosque-breakdown-title-expense"><i class="fa fa-line-chart"></i> Expense Breakdown (Selected)</h4>
                    <table class="mosque-kv">
                        @foreach(($financeBreakdown['expense_sources'] ?? []) as $row)
                            <tr>
                                <td class="mosque-k">
                                    @php($label = (string) ($row['name'] ?? ''))
                                    @if(stripos($label, 'pos purchases') !== false)
                                        @if(stripos($label, 'due') !== false)
                                            <i class="fa fa-clock-o"></i>
                                        @else
                                            <i class="fa fa-truck"></i>
                                        @endif
                                    @elseif(stripos($label, 'module finance') !== false)
                                        <i class="fa fa-book"></i>
                                    @else
                                        <i class="fa fa-circle-o"></i>
                                    @endif
                                    {{ $label }}
                                </td>
                                <td class="mosque-v">
                                    <span class="display_currency mosque-breakdown-amount" data-currency_symbol="true" data-orig-value="{{ (float) ($row['total'] ?? 0) }}">{{ (float) ($row['total'] ?? 0) }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </table>
                    <hr style="margin:12px 0;">
                    <h5 class="mosque-breakdown-subtitle mosque-breakdown-subtitle-expense"><i class="fa fa-tags"></i> By Category (Module)</h5>
                    <table class="mosque-kv">
                        @foreach(($financeBreakdown['expense_categories'] ?? []) as $row)
                            <tr>
                                <td class="mosque-k">{{ $row['name'] }}</td>
                                <td class="mosque-v">
                                    <span class="display_currency mosque-breakdown-amount" data-currency_symbol="true" data-orig-value="{{ (float) ($row['total'] ?? 0) }}">{{ (float) ($row['total'] ?? 0) }}</span>
                                </td>
                            </tr>
                        @endforeach
                        @if(empty($financeBreakdown['expense_categories']))
                            <tr><td class="mosque-k">No categories</td><td class="mosque-v">0</td></tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>

        @if(!empty($financeBreakdown['donation_types']))
            <hr>
            <h4 style="margin-top:0;"><i class="fa fa-heart"></i> Donations by Type (Selected)</h4>
            <div class="row">
                @foreach(($financeBreakdown['donation_types'] ?? []) as $row)
                    <div class="col-sm-3">
                        @component('components.widget', ['class' => 'box-primary mosque-stat-card'])
                            <div class="mosque-stat-title"><i class="fa fa-heart-o"></i> {{ $row['name'] }}</div>
                            <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($row['total'] ?? 0) }}">{{ (float) ($row['total'] ?? 0) }}</div>
                        @endcomponent
                    </div>
                @endforeach
            </div>
        @endif
    @endcomponent

    @if(!empty($pledges) && !empty($pledges['enabled']))
        <div class="row">
            <div class="col-sm-3">
                @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                    <div class="mosque-stat-title"><i class="fa fa-clock-o"></i> Pledges Due Soon</div>
                    <div class="mosque-stat-value">{{ (int) ($pledges['due_soon_count'] ?? 0) }}</div>
                @endcomponent
            </div>
            <div class="col-sm-3">
                @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                    <div class="mosque-stat-title"><i class="fa fa-calendar"></i> Pledges Due (Next 30d)</div>
                    <div class="mosque-stat-value">{{ (int) ($pledges['due_30_count'] ?? 0) }}</div>
                @endcomponent
            </div>
            <div class="col-sm-3">
                @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                    <div class="mosque-stat-title"><i class="fa fa-exclamation-triangle"></i> Pledges Overdue</div>
                    <div class="mosque-stat-value">{{ (int) ($pledges['overdue_count'] ?? 0) }}</div>
                @endcomponent
            </div>
            <div class="col-sm-3">
                @component('components.widget', ['class' => 'box-primary mosque-stat-card mosque-stat-card--blend'])
                    <div class="mosque-stat-title"><i class="fa fa-check-circle"></i> Pledges Fulfilled (Selected)</div>
                    <div class="mosque-stat-value display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($pledges['fulfilled_month'] ?? 0) }}">{{ (float) ($pledges['fulfilled_month'] ?? 0) }}</div>
                    <div class="mosque-subtle">Fulfillment: {{ (float) ($pledges['fulfillment_pct'] ?? 0) }}%</div>
                @endcomponent
            </div>
        </div>
    @endif
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        __currency_convert_recursively($('.content'));

        // Fix legacy encoding typo in Net label and keep the meaning clear.
        try {
            $('.fa-balance-scale').closest('.box-body').find('.mosque-subtle').text('Income − Expense (selected range)');
        } catch (e) {}

        if (typeof dateRangeSettings !== 'undefined') {
            var $dr = $('#mosque_dashboard_date_range');

            var mosqueStart = @json($dateRange['start'] ?? '');
            var mosqueEnd = @json($dateRange['end'] ?? '');

            var settings = $.extend(true, {}, dateRangeSettings);
            var startMoment = mosqueStart ? moment(mosqueStart, 'YYYY-MM-DD', true) : null;
            var endMoment = mosqueEnd ? moment(mosqueEnd, 'YYYY-MM-DD', true) : null;
            if (startMoment && startMoment.isValid()) {
                settings.startDate = startMoment;
            }
            if (endMoment && endMoment.isValid()) {
                settings.endDate = endMoment;
            }
            settings.autoUpdateInput = false;
            settings.locale = settings.locale || {};
            settings.locale.format = 'YYYY-MM-DD';
            settings.locale.separator = ' ~ ';

            $dr.daterangepicker(settings, function (start, end) {
                $dr.val(start.format('YYYY-MM-DD') + ' ~ ' + end.format('YYYY-MM-DD'));
                var url = new URL(window.location.href);
                url.searchParams.set('start_date', start.format('YYYY-MM-DD'));
                url.searchParams.set('end_date', end.format('YYYY-MM-DD'));
                window.location.href = url.toString();
            });
            $dr.on('cancel.daterangepicker', function() {
                var url = new URL(window.location.href);
                url.searchParams.delete('start_date');
                url.searchParams.delete('end_date');
                window.location.href = url.toString();
            });

            if (mosqueStart && mosqueEnd) {
                $dr.val(mosqueStart + ' ~ ' + mosqueEnd);

                // Ensure picker UI highlights the server-selected range after reload.
                var drp = $dr.data('daterangepicker');
                if (drp) {
                    if (startMoment && startMoment.isValid()) {
                        drp.setStartDate(startMoment);
                    }
                    if (endMoment && endMoment.isValid()) {
                        drp.setEndDate(endMoment);
                    }
                }
            }
        }

        // Real-time clock + 3 date lines (EN → AR/Hijri → BN) for Mosque dashboard header.
        (function initMosqueClock() {
            var $wrap = $('#mosque-clock');
            if (!$wrap.length || typeof Intl === 'undefined') {
                return;
            }

            var tz = ($wrap.attr('data-tz') || '').trim() || @json(config('app.timezone'));

            var timeEl = document.getElementById('mc-time');
            var enEl = document.getElementById('mc-en');
            var arEl = document.getElementById('mc-ar');
            var bnEl = document.getElementById('mc-bn');
            if (!timeEl || !enEl || !arEl || !bnEl) {
                return;
            }

            function makeFormatter(locale, opts) {
                try {
                    return new Intl.DateTimeFormat(locale, opts);
                } catch (e) {
                    try {
                        return new Intl.DateTimeFormat('en-US', opts);
                    } catch (e2) {
                        return null;
                    }
                }
            }

            var clockFmt = makeFormatter('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit', hour12: true, timeZone: tz });
            var enDateFmt = makeFormatter('en-GB', { weekday: 'long', day: '2-digit', month: 'long', year: 'numeric', timeZone: tz });
            var bnWeekdayFmt = makeFormatter('bn-BD', { weekday: 'long', timeZone: tz });
            var dayKeyFmt = makeFormatter('en-CA', { year: 'numeric', month: '2-digit', day: '2-digit', timeZone: tz });
            var arHijriFmt = makeFormatter('ar-SA-u-ca-islamic', { weekday: 'long', day: 'numeric', month: 'long', year: 'numeric', timeZone: tz });
            var arGregFmt = makeFormatter('ar', { weekday: 'long', day: 'numeric', month: 'long', year: 'numeric', timeZone: tz });

            if (!clockFmt || !enDateFmt || !bnWeekdayFmt) {
                return;
            }

            var lastDayKey = null;

            function toBnDigits(input) {
                return String(input).replace(/\d/g, function (d) {
                    return '০১২৩৪৫৬৭৮৯'.charAt(parseInt(d, 10));
                });
            }

            function bnOrdinal(day) {
                day = parseInt(day, 10) || 0;
                var d = toBnDigits(day);
                if (day === 1) return d + 'লা';
                if (day === 2) return d + 'রা';
                if (day === 3) return d + 'রা';
                if (day >= 19) return d + 'শে';
                return d + 'ই';
            }

            function tzYmdParts(dateObj) {
                var fmt = makeFormatter('en-CA', { year: 'numeric', month: '2-digit', day: '2-digit', timeZone: tz });
                if (!fmt || !fmt.formatToParts) {
                    return { y: dateObj.getFullYear(), m: dateObj.getMonth() + 1, d: dateObj.getDate() };
                }
                var parts = fmt.formatToParts(dateObj);
                var y = parseInt(parts.find(function (p) { return p.type === 'year'; }).value, 10);
                var m = parseInt(parts.find(function (p) { return p.type === 'month'; }).value, 10);
                var d = parseInt(parts.find(function (p) { return p.type === 'day'; }).value, 10);
                return { y: y, m: m, d: d };
            }

            function utcTs(y, m, d) {
                return Date.UTC(y, m - 1, d);
            }

            function isGregLeapYear(y) {
                return (y % 4 === 0 && y % 100 !== 0) || (y % 400 === 0);
            }

            function bengaliCalendarFromYmd(y, m, d) {
                // Bangladesh (revised) Bangla calendar approximation for UI.
                var afterNewYear = (m > 4) || (m === 4 && d >= 14);
                var by = afterNewYear ? (y - 593) : (y - 594);
                var gyStart = by + 593;
                var gyNext = gyStart + 1;

                var chaitraStartDay = isGregLeapYear(gyNext) ? 15 : 14;

                var monthStarts = [
                    { name: 'বৈশাখ', y: gyStart, m: 4, d: 14 },
                    { name: 'জ্যৈষ্ঠ', y: gyStart, m: 5, d: 15 },
                    { name: 'আষাঢ়', y: gyStart, m: 6, d: 15 },
                    { name: 'শ্রাবণ', y: gyStart, m: 7, d: 16 },
                    { name: 'ভাদ্র', y: gyStart, m: 8, d: 16 },
                    { name: 'আশ্বিন', y: gyStart, m: 9, d: 16 },
                    { name: 'কার্তিক', y: gyStart, m: 10, d: 16 },
                    { name: 'অগ্রহায়ণ', y: gyStart, m: 11, d: 16 },
                    { name: 'পৌষ', y: gyStart, m: 12, d: 16 },
                    { name: 'মাঘ', y: gyNext, m: 1, d: 15 },
                    { name: 'ফাল্গুন', y: gyNext, m: 2, d: 14 },
                    { name: 'চৈত্র', y: gyNext, m: 3, d: chaitraStartDay },
                    { name: 'বৈশাখ', y: gyNext, m: 4, d: 14 },
                ];

                var ts = utcTs(y, m, d);
                var idx = 0;
                for (var i = 0; i < monthStarts.length - 1; i++) {
                    var a = utcTs(monthStarts[i].y, monthStarts[i].m, monthStarts[i].d);
                    var b = utcTs(monthStarts[i + 1].y, monthStarts[i + 1].m, monthStarts[i + 1].d);
                    if (ts >= a && ts < b) {
                        idx = i;
                        break;
                    }
                }

                var startTs = utcTs(monthStarts[idx].y, monthStarts[idx].m, monthStarts[idx].d);
                var dayNo = Math.floor((ts - startTs) / 86400000) + 1;

                var seasonByMonthIndex = [
                    'গ্রীষ্ম-কাল', 'গ্রীষ্ম-কাল',
                    'বর্ষা-কাল', 'বর্ষা-কাল',
                    'শরৎ-কাল', 'শরৎ-কাল',
                    'হেমন্ত-কাল', 'হেমন্ত-কাল',
                    'শীত-কাল', 'শীত-কাল',
                    'বসন্ত-কাল', 'বসন্ত-কাল',
                ];

                return {
                    year: by,
                    monthIndex: idx,
                    monthName: monthStarts[idx].name,
                    day: dayNo,
                    season: seasonByMonthIndex[idx] || '',
                };
            }

            function hijriBnFromDate(dateObj) {
                var hijriPartsFmt = makeFormatter('en-US-u-ca-islamic', { year: 'numeric', month: 'numeric', day: 'numeric', timeZone: tz });
                if (!hijriPartsFmt || !hijriPartsFmt.formatToParts) {
                    return null;
                }

                var parts = hijriPartsFmt.formatToParts(dateObj);
                var y = parseInt(parts.find(function (p) { return p.type === 'year'; }).value, 10);
                var m = parseInt(parts.find(function (p) { return p.type === 'month'; }).value, 10);
                var d = parseInt(parts.find(function (p) { return p.type === 'day'; }).value, 10);

                var monthsBn = [
                    'মুহাররম',
                    'সফর',
                    'রবিউল আউয়াল',
                    'রবিউস সানি',
                    'জমাদিউল আউয়াল',
                    'জমাদিউস সানি',
                    'রজব',
                    'শাবান',
                    'রমজান',
                    'শাওয়াল',
                    'জিলকদ',
                    'জিলহজ',
                ];

                return {
                    year: y,
                    month: m,
                    monthName: monthsBn[m - 1] || '',
                    day: d,
                };
            }

            function setText(el, text) {
                if (el.textContent !== text) {
                    el.textContent = text;
                }
            }

            function renderDates(now) {
                try {
                    setText(enEl, enDateFmt.format(now));
                } catch (e) {
                    setText(enEl, now.toDateString());
                }

                try {
                    if (arHijriFmt) {
                        var hijriText = arHijriFmt.format(now);
                        // Keep Arabic Hijri as fallback only (preferred format is Bangla Hijri below).
                        if (!/[\u0647\u0640]/.test(hijriText)) {
                            hijriText += ' \u0647\u0640';
                        }
                        setText(arEl, hijriText);
                    } else if (arGregFmt) {
                        setText(arEl, arGregFmt.format(now));
                    } else {
                        setText(arEl, '');
                    }
                } catch (e) {
                    setText(arEl, '');
                }

                // Prefer Hijri in Bangla format: ২৯শে জমাদিউস সানি ১৪৪৭ হিজরি
                try {
                    var hijriBn = hijriBnFromDate(now);
                    if (hijriBn) {
                        setText(arEl, bnOrdinal(hijriBn.day) + ' ' + hijriBn.monthName + ' ' + toBnDigits(hijriBn.year) + ' \u09b9\u09bf\u099c\u09b0\u09bf');
                    }
                } catch (e) {
                }

                // Bangla calendar (Bangabda) + season: রবিবার ৬ই পৌষ ১৪৩২ বঙ্গাব্দ + শীত-কাল |
                try {
                    var ymd = tzYmdParts(now);
                    var bc = bengaliCalendarFromYmd(ymd.y, ymd.m, ymd.d);
                    var weekday = bnWeekdayFmt ? bnWeekdayFmt.format(now) : '';
                    var bnLine = weekday + ' ' + bnOrdinal(bc.day) + ' ' + bc.monthName + ' ' + toBnDigits(bc.year) + ' \u09ac\u0999\u09cd\u0997\u09be\u09ac\u09cd\u09a6';
                    var seasonLine = bc.season ? (bc.season + ' |') : '';
                    var html = '<div>' + bnLine + '</div>' + (seasonLine ? ('<div class=\"mc-season\">' + seasonLine + '</div>') : '');
                    if (bnEl.innerHTML !== html) {
                        bnEl.innerHTML = html;
                    }
                } catch (e) {
                    bnEl.innerHTML = '';
                }
            }

            function tick() {
                var now = new Date();

                try {
                    setText(timeEl, clockFmt.format(now));
                } catch (e) {
                    setText(timeEl, '');
                }

                var dayKey = null;
                try {
                    dayKey = dayKeyFmt ? dayKeyFmt.format(now) : null;
                } catch (e) {
                    dayKey = null;
                }

                if (dayKey && dayKey !== lastDayKey) {
                    lastDayKey = dayKey;
                    renderDates(now);
                    return;
                }

                // Refresh date lines at :00 seconds (timezone-respecting) to avoid extra work.
                try {
                    if (clockFmt.formatToParts) {
                        var parts = clockFmt.formatToParts(now);
                        var secPart = parts.find(function (p) { return p.type === 'second'; });
                        if (secPart && secPart.value === '00') {
                            renderDates(now);
                        }
                    }
                } catch (e) {
                }
            }

            tick();
            setInterval(tick, 1000);
        })();
    });
</script>
@endsection
