@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_death'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_death')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('lang_v1.start_date')</label>
                    <input type="date" id="mdt_start_date" class="form-control">
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('lang_v1.end_date')</label>
                    <input type="date" id="mdt_end_date" class="form-control">
                </div>
            </div>
            <div class="col-sm-8 text-right">
                <a href="{{ route('mosque.death.reports') }}" class="btn btn-default">
                    <i class="fa fa-bar-chart"></i> @lang('mosque::mosque.menu_death_reports')
                </a>
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.death.create') }}" data-container=".mosque_death_modal">
                    <i class="fa fa-plus"></i> @lang('messages.add')
                </button>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_death_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Certificate</th>
                        <th>Name</th>
                        <th>Burial Place</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_death_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var table = $('#mosque_death_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.death.data") }}',
                data: function (d) {
                    d.start_date = $('#mdt_start_date').val();
                    d.end_date = $('#mdt_end_date').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'date', name: 'date' },
                { data: 'certificate_no', name: 'certificate_no' },
                { data: 'name', name: 'name' },
                { data: 'burial_place', name: 'burial_place' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });

        table.on('init.dt', function () {
            $('#mosque_death_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('change', '#mdt_start_date, #mdt_end_date', function () {
            table.ajax.reload();
        });

        $(document).on('submit', 'form#mosque_death_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_death_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () { toastr.error('@lang("messages.something_went_wrong")'); }
            });
        });

        $(document).on('click', '.delete_mosque_death', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            swal({ title: LANG.sure, icon: 'warning', buttons: true, dangerMode: true })
            .then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        method: 'DELETE',
                        url: href,
                        data: { _token: '{{ csrf_token() }}' },
                        success: function (result) {
                            if (result.success) {
                                toastr.success(result.msg);
                                table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
    });
</script>
@endsection
