<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@lang('mosque::mosque.menu_death') - {{ $death->certificate_no }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 24px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 16px; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid td { padding: 8px 6px; vertical-align: top; }
        .label { width: 180px; color: #333; font-weight: bold; }
        .footer { margin-top: 22px; display: flex; justify-content: space-between; gap: 20px; }
        .sig { width: 48%; border-top: 1px solid #333; padding-top: 6px; font-size: 12px; color: #333; }
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; }
        }
    </style>
</head>
<body>
    <div class="no-print" style="text-align:right;margin-bottom:10px;">
        <button onclick="window.print();" type="button">Print</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;
        $logoUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try {
                $logoUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo);
            } catch (\Exception $e) {
                $logoUrl = null;
            }
        }
    @endphp

    <div class="header">
        <div style="display:flex;justify-content:space-between;gap:12px;align-items:center;">
            <div>
                <h1>Death Certificate</h1>
                <div class="muted">
                    {{ $headerName }} &nbsp;|&nbsp; Certificate No: {{ $death->certificate_no }}
                </div>
            </div>
            @if(!empty($logoDataUri) || !empty($logoUrl))
                <div><img src="{{ $logoDataUri ?? $logoUrl }}" alt="Logo" style="max-height:60px;"></div>
            @endif
        </div>
    </div>

    <table class="grid">
        <tr>
            <td class="label">Date</td>
            <td>{{ ! empty($death->date) ? \Carbon\Carbon::parse($death->date)->format('Y-m-d') : '-' }}</td>
        </tr>
        <tr>
            <td class="label">Deceased Name</td>
            <td>{{ $death->name }}</td>
        </tr>
        <tr>
            <td class="label">Burial Place</td>
            <td>{{ $death->burial_place ?: '-' }}</td>
        </tr>
        <tr>
            <td class="label">Notes</td>
            <td>{!! nl2br(e($death->notes ?? '')) ?: '-' !!}</td>
        </tr>
    </table>

    @if(!empty($profile) && !empty($profile->header_text))
        <div style="margin-top:14px;" class="muted">
            {!! nl2br(e($profile->header_text)) !!}
        </div>
    @endif

    <div class="footer">
        <div class="sig">Authorized Signature</div>
        <div class="sig">Witness / Registrar</div>
    </div>
</body>
</html>
