@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_death_reports'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_death_reports')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('lang_v1.start_date')</label>
                    <input type="date" id="dtr_start_date" class="form-control" value="{{ now()->startOfYear()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('lang_v1.end_date')</label>
                    <input type="date" id="dtr_end_date" class="form-control" value="{{ now()->endOfYear()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Year</label>
                    <select id="dtr_year" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        @php $y = (int) now()->format('Y'); @endphp
                        @for($i = 0; $i <= 10; $i++)
                            <option value="{{ $y - $i }}">{{ $y - $i }}</option>
                        @endfor
                    </select>
                </div>
            </div>
            <div class="col-sm-3 text-right">
                <a href="{{ route('mosque.death') }}" class="btn btn-default" style="margin-top:24px;">
                    <i class="fa fa-list"></i> Register
                </a>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs">
            <li class="active"><a href="#tab_yearly" data-toggle="tab">Yearly Stats</a></li>
            <li><a href="#tab_register" data-toggle="tab">Register</a></li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div class="tab-pane active" id="tab_yearly">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_death_yearly_report" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Year</th>
                                <th>Deaths</th>
                                <th>Burial Places</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_register">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_death_register_report" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Certificate</th>
                                <th>Name</th>
                                <th>Burial Place</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>

                <div class="modal fade mosque_death_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
            </div>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(document).ready(function () {
    function getFilters() {
        return {
            start_date: $('#dtr_start_date').val(),
            end_date: $('#dtr_end_date').val(),
            year: $('#dtr_year').val(),
        };
    }

    var yearlyTable = $('#mosque_death_yearly_report').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.death.reports.yearly") }}',
            data: function (d) {
                return $.extend({}, d, getFilters());
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'year', name: 'year' },
            { data: 'deaths_count', name: 'deaths_count', searchable: false },
            { data: 'burial_places_count', name: 'burial_places_count', searchable: false },
        ]
    });

    var registerTable = $('#mosque_death_register_report').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.death.data") }}',
            data: function (d) {
                return $.extend({}, d, { start_date: $('#dtr_start_date').val(), end_date: $('#dtr_end_date').val() });
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'date', name: 'date' },
            { data: 'certificate_no', name: 'certificate_no' },
            { data: 'name', name: 'name' },
            { data: 'burial_place', name: 'burial_place' },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ]
    });

    yearlyTable.on('init.dt', function () {
        $('#mosque_death_yearly_report_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });
    registerTable.on('init.dt', function () {
        $('#mosque_death_register_report_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });

    $(document).on('change', '#dtr_start_date, #dtr_end_date, #dtr_year', function () {
        yearlyTable.ajax.reload();
        registerTable.ajax.reload();
    });
});
</script>
@endsection
