<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.donations.update', $donation->id), 'method' => 'post', 'id' => 'mosque_donation_form']) !!}
        {!! Form::hidden('_method', 'PUT') !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.edit')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('date', __('lang_v1.date') . ':*') !!}
                        {!! Form::date('date', !empty($donation->date) ? $donation->date->format('Y-m-d') : null, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('amount', __('sale.total_amount') . ':*') !!}
                        {!! Form::number('amount', $donation->amount, ['class' => 'form-control', 'step' => '0.01', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('type', 'Type:*') !!}
                        {!! Form::select('type', ['zakat' => 'Zakat', 'sadaqah' => 'Sadaqah', 'fitrah' => 'Fitrah', 'general' => 'General', 'event' => 'Event', 'waqf' => 'Waqf'], $donation->type, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('channel', 'Channel:*') !!}
                        {!! Form::select('channel', ['cash' => 'Cash', 'bank' => 'Bank', 'card' => 'Card', 'online' => 'Online'], $donation->channel, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="checkbox" style="margin-top:25px;">
                        <label>
                            {!! Form::checkbox('anonymous', 1, (bool)$donation->anonymous, ['id' => 'md_anonymous']) !!} Anonymous
                        </label>
                    </div>
                </div>
                <div class="col-sm-6" id="md_donor_wrap">
                    <div class="form-group">
                        {!! Form::label('donor_id', 'Donor:') !!}
                        {!! Form::select('donor_id', $donors, $donation->donor_id, ['class' => 'form-control', 'placeholder' => __('lang_v1.none')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('notes', $donation->notes, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        function toggleWrap() {
            if ($('#md_anonymous').is(':checked')) {
                $('#md_donor_wrap').addClass('hide');
            } else {
                $('#md_donor_wrap').removeClass('hide');
            }
        }
        toggleWrap();
        $(document).on('change', '#md_anonymous', toggleWrap);
    });
</script>

