<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Donation Receipt - {{ $donation->receipt_no }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { text-align: right; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .subtle { color: #444; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid td { padding: 7px 6px; vertical-align: top; }
        .label { width: 180px; color: #333; font-weight: bold; }
        .box { border: 1px solid #ddd; padding: 10px; border-radius: 4px; margin-top: 12px; font-size: 12px; }
        .section-title { font-weight: bold; font-size: 13px; margin: 0 0 6px 0; }
        .pay-grid { width: 100%; border-collapse: collapse; margin-top: 6px; }
        .pay-grid td { vertical-align: top; padding: 6px; width: 33.33%; }
        .pay-box { border: 1px solid #ddd; border-radius: 4px; padding: 8px; min-height: 84px; }
        .pay-box h3 { margin: 0 0 6px 0; font-size: 12px; }
        .pay-box ul { margin: 0; padding-left: 16px; }
        .pay-box li { margin: 0 0 2px 0; }
        .sig-row { margin-top: 18px; display: flex; justify-content: center; }
        .sig { width: 320px; text-align: center; }
        .sig .line { border-top: 1px solid #111; margin-top: 36px; padding-top: 4px; font-size: 12px; font-weight: bold; }
        .tech { margin-top: 12px; text-align: center; font-size: 12px; font-weight: bold; color: #111; }
        .footer { margin-top: 10px; font-size: 11px; color: #666; text-align: right; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;
        $mosqueAddress = !empty($profile) && !empty($profile->address) ? (string) $profile->address : '';
        $logoUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try {
                $logoUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo);
            } catch (\Exception $e) {
                $logoUrl = null;
            }
        }
        $euWording = (string) ($settings['eu_receipt_wording'] ?? '');
        $template = (string) ($settings['template_donation_receipt'] ?? '');
        $donorName = ($donation->anonymous || empty($donor)) ? 'Anonymous' : ($donor->name ?? '');
        $donorPhone = '';
        $donorWhatsapp = '';
        if (! $donation->anonymous && ! empty($donor)) {
            $donorPhone = trim((string) ($donor->phone ?? ''));
            $donorWhatsapp = trim((string) ($donor->whatsapp_number ?? ''));
            if ($donorWhatsapp === '' && ! empty($donor->whatsapp_same_as_phone) && $donorPhone !== '') {
                $donorWhatsapp = $donorPhone;
            }
        }
        $amountFormatted = \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($donation->amount, $settings ?? []);

        $dpi = (array) ($settings['donation_payment_info'] ?? []);
        $dpiMobile = array_values((array) ($dpi['mobile'] ?? []));
        $dpiBank = array_values((array) ($dpi['bank'] ?? []));
        $dpiCash = (array) ($dpi['cash'] ?? []);
        $techPartner = 'পল্লীটেক্স | 01918090809';
        $generatedOn = now()->format('Y-m-d H:i');

        $tokens = [
            '{business}' => $businessName,
            '{receipt_no}' => (string) $donation->receipt_no,
            '{date}' => !empty($donation->date) ? \Carbon\Carbon::parse($donation->date)->format('Y-m-d') : '',
            '{amount}' => (string) $amountFormatted,
            '{type}' => (string) $donation->type,
            '{channel}' => (string) $donation->channel,
            '{donor}' => (string) $donorName,
        ];
        $templateRendered = trim(strtr($template, $tokens));
    @endphp

    <div class="header">
        <div class="row" style="display:flex;justify-content:space-between;align-items:center;gap:12px;">
            <div>
                <h1 style="margin:0;">Donation Receipt</h1>
                <div class="muted">
                    {{ $headerName }} &nbsp;|&nbsp; Receipt: {{ $donation->receipt_no }}
                </div>
                @if(!empty($mosqueAddress))
                    <div class="subtle">{!! nl2br(e($mosqueAddress)) !!}</div>
                @endif
                <div class="muted">Computer Generated Receipt</div>
            </div>
            @if(!empty($logoDataUri) || !empty($logoUrl))
                <div>
                    <img src="{{ $logoDataUri ?? $logoUrl }}" alt="Logo" style="max-height:60px;">
                </div>
            @endif
        </div>
    </div>

    <table class="grid">
        <tr>
            <td class="label">Generated on</td>
            <td>{{ $generatedOn }}</td>
        </tr>
        <tr>
            <td class="label">Date</td>
            <td>{{ ! empty($donation->date) ? \Carbon\Carbon::parse($donation->date)->format('Y-m-d') : '-' }}</td>
        </tr>
        <tr>
            <td class="label">Donor</td>
            <td>{{ $donorName }}</td>
        </tr>
        <tr>
            <td class="label">Donor Contact</td>
            <td>
                @if(!empty($donation->anonymous) || empty($donor))
                    -
                @else
                    @php
                        $parts = [];
                        if ($donorPhone !== '') { $parts[] = 'Phone: '.$donorPhone; }
                        if ($donorWhatsapp !== '' && $donorWhatsapp !== $donorPhone) { $parts[] = 'WhatsApp: '.$donorWhatsapp; }
                        if ($donorWhatsapp !== '' && $donorWhatsapp === $donorPhone) { $parts[] = 'WhatsApp: '.$donorWhatsapp; }
                    @endphp
                    {{ !empty($parts) ? implode(' | ', $parts) : '-' }}
                @endif
            </td>
        </tr>
        <tr>
            <td class="label">Type</td>
            <td>{{ strtoupper((string) $donation->type) }} @if(!empty($donation->fund_tag)) ({{ $donation->fund_tag }}) @endif</td>
        </tr>
        <tr>
            <td class="label">Channel</td>
            <td>{{ strtoupper((string) $donation->channel) }}</td>
        </tr>
        <tr>
            <td class="label">Amount</td>
            <td><strong>{{ $amountFormatted }}</strong></td>
        </tr>
        <tr>
            <td class="label">Notes</td>
            <td>{!! nl2br(e($donation->notes ?? '')) ?: '-' !!}</td>
        </tr>
    </table>

    @if(!empty($dpiMobile) || !empty($dpiBank) || !empty($dpiCash))
        <div class="box">
            <div class="section-title">Payment Information</div>
            <table class="pay-grid">
                <tr>
                    <td>
                        <div class="pay-box">
                            <h3>Mobile Payment Gateway</h3>
                            @if(empty($dpiMobile))
                                <div class="muted">—</div>
                            @else
                                <ul>
                                    @foreach($dpiMobile as $m)
                                        @php
                                            $m = (array) $m;
                                            $mn = trim((string) ($m['name'] ?? ''));
                                            $mno = trim((string) ($m['number'] ?? ''));
                                            $mnote = trim((string) ($m['note'] ?? ''));
                                            $line = trim($mn.($mno !== '' ? ' - '.$mno : ''));
                                        @endphp
                                        @if($line !== '')
                                            <li>
                                                {{ $line }}@if($mnote !== '') <span class="muted">({{ $mnote }})</span>@endif
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </td>
                    <td>
                        <div class="pay-box">
                            <h3>Bank</h3>
                            @if(empty($dpiBank))
                                <div class="muted">—</div>
                            @else
                                <ul>
                                    @foreach($dpiBank as $b)
                                        @php
                                            $b = (array) $b;
                                            $bankName = trim((string) ($b['bank_name'] ?? ''));
                                            $accountName = trim((string) ($b['account_name'] ?? ''));
                                            $accountNo = trim((string) ($b['account_no'] ?? ''));
                                            $branch = trim((string) ($b['branch'] ?? ''));
                                            $routing = trim((string) ($b['routing'] ?? ''));
                                            $bnote = trim((string) ($b['note'] ?? ''));
                                        @endphp
                                        @if($bankName !== '' || $accountNo !== '' || $accountName !== '')
                                            <li>
                                                @if($bankName !== '') {{ $bankName }}@endif
                                                @if($accountName !== '') <span class="muted">|</span> {{ $accountName }}@endif
                                                @if($accountNo !== '') <span class="muted">|</span> {{ $accountNo }}@endif
                                                @if($branch !== '') <span class="muted">|</span> {{ $branch }}@endif
                                                @if($routing !== '') <span class="muted">|</span> {{ $routing }}@endif
                                                @if($bnote !== '') <span class="muted">({{ $bnote }})</span>@endif
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </td>
                    <td>
                        <div class="pay-box">
                            <h3>Cash on Hand</h3>
                            @php
                                $cashLabel = trim((string) ($dpiCash['label'] ?? ''));
                                $cashNote = trim((string) ($dpiCash['note'] ?? ''));
                            @endphp
                            @if($cashLabel === '' && $cashNote === '')
                                <div class="muted">—</div>
                            @else
                                <div>
                                    @if($cashLabel !== '') <strong>{{ $cashLabel }}</strong>@endif
                                    @if($cashNote !== '') <div class="muted">{{ $cashNote }}</div>@endif
                                </div>
                            @endif
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    @endif

    @if(!empty($euWording))
        <div class="box">
            {!! nl2br(e($euWording)) !!}
        </div>
    @endif

    @if(!empty($templateRendered))
        <div class="box">
            {!! nl2br(e($templateRendered)) !!}
        </div>
    @endif

    @if(!empty($profile) && !empty($profile->header_text))
        <div class="box">
            {!! nl2br(e($profile->header_text)) !!}
        </div>
    @endif

    <div class="sig-row">
        <div class="sig">
            <div class="line">Authorised Signature</div>
        </div>
    </div>

    <div class="tech">{{ $techPartner }}</div>
</body>
</html>
