<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $link->title ?: 'Donation' }}</title>
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <style>
        body { font-family: Arial, sans-serif; padding: 14px; background: #f5f7fb; }
        .wrap { max-width: 980px; margin: 0 auto; }
        .card { background: #fff; border-radius: 10px; box-shadow: 0 10px 28px rgba(18, 38, 63, .10); padding: 14px; }
        .btn-primary { background: {{ $link->primary_color ?: '#000000' }}; border-color: {{ $link->primary_color ?: '#000000' }}; font-weight: 800; color:#fff !important; }
        .btn-primary:hover, .btn-primary:focus { background: {{ $link->primary_color ?: '#000000' }}; border-color: {{ $link->primary_color ?: '#000000' }}; color:#fff !important; opacity: .92; }
        .muted { color: #666; font-size: 12px; }
        .title { font-size: 18px; font-weight: 800; margin: 0; }
        .sub { margin-top: 4px; }
        .sec-title { font-weight: 800; margin: 10px 0 8px 0; border-bottom: 1px solid #e5e7eb; margin-top: 16px; padding-bottom: 6px; }
        .help { font-size: 12px; color: #555; margin-top: 4px; }
        .req { color: #d32f2f; font-weight: 800; }
        .pay-wrap { background: #fbfbfe; border: 1px solid #e5e7eb; border-radius: 10px; padding: 12px; }
        .pay-grid { display: grid; grid-template-columns: 1fr; gap: 10px; }
        @media (min-width: 600px) { .pay-grid { grid-template-columns: repeat(3, 1fr); } }
        .pay-box { border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px; background: #fff; min-height: 92px; }
        .pay-box h4 { margin: 0 0 6px 0; font-size: 13px; font-weight: 800; }
        .pay-box ul { margin: 0; padding-left: 16px; }
        .pay-box li { margin: 0 0 2px 0; font-size: 12px; }
        .ig .input-group-addon { background:#f8fafc; border-color:#e5e7eb; color:#0f172a; }
        .ig .form-control { border-color:#e5e7eb; }
        .ig .form-control:focus { border-color: {{ $link->primary_color ?: '#000000' }}; box-shadow: 0 0 0 3px rgba(15, 23, 42, .08); }
        .alert { border-radius: 10px; }
        .btn-submit { padding: 12px 14px; font-size: 16px; border-radius: 10px; }
        .btn-submit[disabled] { opacity: .75; }
        label { display:block; margin-bottom: 6px; }
        .form-group { margin-bottom: 10px; }
        .ig { width: 100%; }
        .ig .input-group-addon { min-width: 42px; text-align: center; }
        .ig .form-control { height: 40px; }
        .ig textarea.form-control { height: auto; min-height: 40px; resize: vertical; }
        .compact-help { margin-top: 2px; }
        /* New compact QR form (keep old markup hidden; append-only) */
        #mosque_public_donation_form { display: none !important; }
    </style>
</head>
<body>
    <div class="wrap">
        @php
            $mosqueName = !empty($profile) && !empty($profile->name) ? (string) $profile->name : ($link->title ?: 'Donation');
            $mosqueAddress = !empty($profile) && !empty($profile->address) ? (string) $profile->address : '';

            $dpi = (array) (($settings ?? [])['donation_payment_info'] ?? []);
            $dpiMobile = array_values((array) ($dpi['mobile'] ?? []));
            $dpiBank = array_values((array) ($dpi['bank'] ?? []));
            $dpiCash = (array) ($dpi['cash'] ?? []);
        @endphp

        <div class="card">
            <p class="title">{{ $mosqueName }}</p>
            @if($mosqueAddress !== '')
                <p class="muted sub">{!! nl2br(e($mosqueAddress)) !!}</p>
            @endif
            <p class="muted sub">Please submit your donation details. This request will be reviewed and approved by the mosque before it appears in the donation history.</p>

            @if(session('status'))
                @php $st = session('status'); @endphp
                <div class="alert alert-{{ !empty($st['success']) ? 'success' : 'danger' }}" role="alert" style="display:flex;gap:10px;align-items:flex-start;">
                    <div style="font-size:18px;line-height:1;">
                        @if(!empty($st['success']))
                            <i class="fa fa-check-circle"></i>
                        @else
                            <i class="fa fa-exclamation-triangle"></i>
                        @endif
                    </div>
                    <div style="font-weight:700;">{{ $st['msg'] ?? '' }}</div>
                </div>
            @endif

            @includeIf('modules.mosque.donations.qr_form', ['embed' => true])

            <form method="post" action="{{ route('mosque.donate.public.submit', [$link->token]) }}" enctype="multipart/form-data" id="mosque_public_donation_form">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-xs-12 col-lg-7">
                        <div class="row">
                            <div class="col-xs-12 col-sm-6 col-lg-3">
                                <div class="form-group">
                                    <label>Amount <span class="req">*</span></label>
                                    <div class="input-group ig">
                                        <span class="input-group-addon"><i class="fa fa-money"></i></span>
                                        <input type="number" class="form-control" name="amount" required step="0.01" min="0.01" inputmode="decimal" placeholder="0.00">
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6 col-lg-3">
                                <div class="form-group">
                                    <label>Type <span class="req">*</span></label>
                                    <div class="input-group ig">
                                        <span class="input-group-addon"><i class="fa fa-tags"></i></span>
                                        <select class="form-control" name="type" required>
                                            <option value="general">General</option>
                                            <option value="zakat">Zakat</option>
                                            <option value="sadaqah">Sadaqah</option>
                                            <option value="fitrah">Fitrah</option>
                                            <option value="event">Event</option>
                                            <option value="waqf">Waqf</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6 col-lg-3">
                                <div class="form-group">
                                    <label>Channel <span class="req">*</span></label>
                                    <div class="input-group ig">
                                        <span class="input-group-addon"><i class="fa fa-credit-card"></i></span>
                                        <select class="form-control" name="channel" required>
                                            <option value="cash">Cash</option>
                                            <option value="bank">Bank</option>
                                            <option value="card">Card</option>
                                            <option value="online">Online</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6 col-lg-3">
                                <div class="checkbox" style="margin-top:28px; margin-bottom:10px;">
                                    <label style="font-weight:800;">
                                        <input type="checkbox" name="anonymous" value="1" id="don_anon">
                                        <i class="fa fa-user-secret" style="margin-right:4px;"></i> Anonymous
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="sec-title" style="margin-top:10px;">Transaction Details</div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label>Transaction Reference <span class="req">*</span></label>
                                    <div class="input-group ig">
                                        <span class="input-group-addon"><i class="fa fa-receipt"></i></span>
                                        <input type="text" class="form-control" name="transaction_ref" required maxlength="120" placeholder="bKash Txn ID / Bank Ref / Screenshot ID">
                                    </div>
                                    <div class="help compact-help">Enter transaction ID/reference.</div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label>Transaction Photo <span class="req">*</span></label>
                                    <div class="input-group ig">
                                        <span class="input-group-addon"><i class="fa fa-image"></i></span>
                                        <input type="file" class="form-control" name="transaction_image" required accept="image/*" capture="environment">
                                    </div>
                                    <div class="help compact-help">Upload payment proof.</div>
                                </div>
                            </div>
                        </div>

                        <div id="donor_wrap">
                            <div class="sec-title" style="margin-top:10px;">Donor (optional)</div>
                            <div class="row">
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label>Name</label>
                                        <div class="input-group ig">
                                            <span class="input-group-addon"><i class="fa fa-user"></i></span>
                                            <input type="text" class="form-control" name="donor_name" placeholder="Full name">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label>Email</label>
                                        <div class="input-group ig">
                                            <span class="input-group-addon"><i class="fa fa-envelope"></i></span>
                                            <input type="email" class="form-control" name="donor_email" placeholder="example@email.com">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label>Phone</label>
                                        <div class="input-group ig">
                                            <span class="input-group-addon"><i class="fa fa-phone"></i></span>
                                            <input type="text" class="form-control" name="donor_phone" placeholder="01XXXXXXXXX">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label>Address</label>
                                        <div class="input-group ig">
                                            <span class="input-group-addon"><i class="fa fa-map-marker"></i></span>
                                            <input type="text" class="form-control" name="donor_address" placeholder="Address">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>Notes (optional)</label>
                            <div class="input-group ig">
                                <span class="input-group-addon"><i class="fa fa-comment"></i></span>
                                <textarea class="form-control" name="notes" rows="2" placeholder="Any message for the mosque"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="col-xs-12 col-lg-5">
                        <div class="sec-title" style="margin-top:0;">Payment Information</div>
                        <div class="pay-wrap">
                    <div class="pay-grid">
                        <div class="pay-box">
                            <h4>Mobile Payment</h4>
                            @if(empty($dpiMobile))
                                <div class="muted">&mdash;</div>
                            @else
                                <ul>
                                    @foreach($dpiMobile as $m)
                                        @php
                                            $m = (array) $m;
                                            $mn = trim((string) ($m['name'] ?? ''));
                                            $mno = trim((string) ($m['number'] ?? ''));
                                            $mnote = trim((string) ($m['note'] ?? ''));
                                            $line = trim($mn.($mno !== '' ? ' - '.$mno : ''));
                                        @endphp
                                        @if($line !== '')
                                            <li>{{ $line }}@if($mnote !== '') <span class="muted">({{ $mnote }})</span>@endif</li>
                                        @endif
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                        <div class="pay-box">
                            <h4>Bank</h4>
                            @if(empty($dpiBank))
                                <div class="muted">&mdash;</div>
                            @else
                                <ul>
                                    @foreach($dpiBank as $b)
                                        @php
                                            $b = (array) $b;
                                            $bankName = trim((string) ($b['bank_name'] ?? ''));
                                            $accountName = trim((string) ($b['account_name'] ?? ''));
                                            $accountNo = trim((string) ($b['account_no'] ?? ''));
                                        @endphp
                                        @if($bankName !== '' || $accountNo !== '' || $accountName !== '')
                                            <li>
                                                @if($bankName !== '') {{ $bankName }}@endif
                                                @if($accountName !== '') <span class="muted">|</span> {{ $accountName }}@endif
                                                @if($accountNo !== '') <span class="muted">|</span> {{ $accountNo }}@endif
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                        <div class="pay-box">
                            <h4>Cash</h4>
                            @php
                                $cashLabel = trim((string) ($dpiCash['label'] ?? ''));
                                $cashNote = trim((string) ($dpiCash['note'] ?? ''));
                            @endphp
                            @if($cashLabel === '' && $cashNote === '')
                                <div class="muted">&mdash;</div>
                            @else
                                <div style="font-size:12px;">
                                    @if($cashLabel !== '') <strong>{{ $cashLabel }}</strong>@endif
                                    @if($cashNote !== '') <div class="muted">{{ $cashNote }}</div>@endif
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="help" style="margin-top:8px;">Use the above payment details and upload your transaction proof.</div>
                </div>
                    </div>
                </div>

                <div style="margin-top:14px;">
                    <button type="submit" class="btn btn-primary btn-block btn-submit" id="mosque_public_donation_submit_btn">
                        <i class="fa fa-paper-plane" style="margin-right:6px;"></i> Submit for Approval
                    </button>
                </div>
            </form>
        </div>

        <p class="muted" style="margin-top:10px;text-align:center;">Your donation request will be reviewed by the mosque. Thank you.</p>
        </div>

    <script src="{{ asset('js/vendor.js') }}"></script>
    <script src="{{ asset('js/functions.js') }}"></script>
    <script src="{{ asset('js/common.js') }}"></script>
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="{{ asset('js/mosque_donation_qr.js') }}"></script>
    <script>
        (function () {
            var anon = document.getElementById('don_anon');
            var wrap = document.getElementById('donor_wrap');
            if (!anon || !wrap) return;
            anon.addEventListener('change', function () {
                wrap.style.display = anon.checked ? 'none' : 'block';
            });
        })();

        (function () {
            var form = document.getElementById('mosque_public_donation_form');
            var btn = document.getElementById('mosque_public_donation_submit_btn');
            if (form && btn) {
                form.addEventListener('submit', function () {
                    btn.disabled = true;
                    btn.innerHTML = '<i class="fa fa-spinner fa-spin" style="margin-right:6px;"></i> Submitting...';
                });
            }
        })();

        (function () {
            var ok = {{ !empty($st['success']) ? 'true' : 'false' }};
            if (!ok) return;
            try {
                var ctx = new (window.AudioContext || window.webkitAudioContext)();
                var osc = ctx.createOscillator();
                var gain = ctx.createGain();
                osc.type = 'sine';
                osc.frequency.value = 880;
                gain.gain.value = 0.06;
                osc.connect(gain);
                gain.connect(ctx.destination);
                osc.start();
                setTimeout(function () { osc.stop(); ctx.close(); }, 120);
            } catch (e) {
                // ignore
            }
        })();
    </script>
</body>
</html>
