@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Donation Reports')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Donation Reports</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3" style="display:none;">
                <div class="form-group">
                    <label>@lang('lang_v1.start_date')</label>
                    <input type="date" id="mdr_start_date" class="form-control" value="{{ now()->startOfYear()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-3" style="display:none;">
                <div class="form-group">
                    <label>@lang('lang_v1.end_date')</label>
                    <input type="date" id="mdr_end_date" class="form-control" value="{{ now()->endOfYear()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-4">
                <div class="form-group">
                    <label>@lang('report.date_range')</label>
                    <input type="text" id="mdr_date_range" class="form-control" readonly autocomplete="off" placeholder="@lang('lang_v1.select_a_date_range')">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Type</label>
                    <select id="mdr_type" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="zakat">Zakat</option>
                        <option value="sadaqah">Sadaqah</option>
                        <option value="fitrah">Fitrah</option>
                        <option value="general">General</option>
                        <option value="event">Event</option>
                        <option value="waqf">Waqf</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Channel</label>
                    <select id="mdr_channel" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="cash">Cash</option>
                        <option value="bank">Bank</option>
                        <option value="card">Card</option>
                        <option value="online">Online</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Year</label>
                    <select id="mdr_year" class="form-control">
                        @php $y = (int) now()->format('Y'); @endphp
                        @for($i = 0; $i <= 80; $i++)
                            <option value="{{ $y + $i }}" {{ $i === 0 ? 'selected' : '' }}>{{ $y + $i }}</option>
                        @endfor
                    </select>
                    <p class="help-block">Used on Annual Summary tab.</p>
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-4">
                <div class="well well-sm">
                    <strong>Zakat Collected (Donations):</strong>
                    <span id="mdr_zakat_collected" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="well well-sm">
                    <strong>Zakat Distributed (Expense):</strong>
                    <span id="mdr_zakat_distributed" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="well well-sm">
                    <strong>Zakat Balance:</strong>
                    <span id="mdr_zakat_balance" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs">
            <li class="active"><a href="#tab_donor" data-toggle="tab">Donor Summary</a></li>
            <li><a href="#tab_type" data-toggle="tab">Type Summary</a></li>
            <li><a href="#tab_annual" data-toggle="tab">Annual Summary</a></li>
            <li><a href="#tab_receipts" data-toggle="tab">Receipt Register</a></li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div class="tab-pane active" id="tab_donor">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_donation_donor_report" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Donor</th>
                                <th>Donations</th>
                                <th>Total</th>
                                <th>Zakat Total</th>
                                <th>Last Donation</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_type">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_donation_type_report" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Type</th>
                                <th>Donations</th>
                                <th>Total</th>
                                <th>Zakat Total</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_annual">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_donation_annual_report" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Year</th>
                                <th>Donor</th>
                                <th>Donations</th>
                                <th>Total</th>
                                <th>Zakat Total</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_receipts">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_donation_receipt_register" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Receipt</th>
                                <th>Donor</th>
                                <th>Type</th>
                                <th>Channel</th>
                                <th>Amount</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(document).ready(function () {
    function resetDonationReportFiltersToDefault() {
        var s = moment().startOf('year');
        var e = moment().endOf('year');
        $('#mdr_start_date').val(s.format('YYYY-MM-DD'));
        $('#mdr_end_date').val(e.format('YYYY-MM-DD'));
        if ($('#mdr_date_range').length && typeof moment_date_format !== 'undefined') {
            $('#mdr_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
        }
    }

    // Force defaults on reload.
    resetDonationReportFiltersToDefault();

    if (typeof dateRangeSettings !== 'undefined' && $('#mdr_date_range').length) {
        var start = moment($('#mdr_start_date').val(), 'YYYY-MM-DD');
        var end = moment($('#mdr_end_date').val(), 'YYYY-MM-DD');
        $('#mdr_date_range').daterangepicker(
            $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
            function (s, e) {
                $('#mdr_start_date').val(s.format('YYYY-MM-DD'));
                $('#mdr_end_date').val(e.format('YYYY-MM-DD'));
                $('#mdr_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                donorTable.ajax.reload();
                typeTable.ajax.reload();
                annualTable.ajax.reload();
                receiptsTable.ajax.reload();
                refreshZakatSummary();
            }
        );
        $('#mdr_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
        $('#mdr_date_range').on('cancel.daterangepicker', function() {
            resetDonationReportFiltersToDefault();
            donorTable.ajax.reload();
            typeTable.ajax.reload();
            annualTable.ajax.reload();
            receiptsTable.ajax.reload();
            refreshZakatSummary();
        });
    }

    function getFilters() {
        return {
            start_date: $('#mdr_start_date').val(),
            end_date: $('#mdr_end_date').val(),
            type: $('#mdr_type').val(),
            channel: $('#mdr_channel').val(),
            year: $('#mdr_year').val(),
        };
    }

    function refreshZakatSummary() {
        $.ajax({
            method: 'GET',
            url: '{{ route("mosque.donations.reports.zakat") }}',
            data: { start_date: $('#mdr_start_date').val(), end_date: $('#mdr_end_date').val() },
            success: function (result) {
                if (result && result.success) {
                    $('#mdr_zakat_collected').attr('data-orig-value', result.collected).text(result.collected);
                    $('#mdr_zakat_distributed').attr('data-orig-value', result.distributed).text(result.distributed);
                    $('#mdr_zakat_balance').attr('data-orig-value', result.balance).text(result.balance);
                    __currency_convert_recursively($('.content'));
                }
            }
        });
    }

    var donorTable = $('#mosque_donation_donor_report').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.donations.reports.donors") }}',
            data: function (d) {
                return $.extend({}, d, getFilters());
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'donor_name', name: 'donor_name' },
            { data: 'donations_count', name: 'donations_count', orderable: false, searchable: false },
            { data: 'total_amount', name: 'total_amount', orderable: false, searchable: false },
            { data: 'zakat_amount', name: 'zakat_amount', orderable: false, searchable: false },
            { data: 'last_donation_date', name: 'last_donation_date', orderable: false, searchable: false },
        ],
        drawCallback: function () {
            __currency_convert_recursively($('#mosque_donation_donor_report'));
        }
    });

    var typeTable = $('#mosque_donation_type_report').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.donations.reports.types") }}',
            data: function (d) {
                return $.extend({}, d, getFilters());
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'type', name: 'type' },
            { data: 'donations_count', name: 'donations_count', orderable: false, searchable: false },
            { data: 'total_amount', name: 'total_amount', orderable: false, searchable: false },
            { data: 'zakat_amount', name: 'zakat_amount', orderable: false, searchable: false },
        ],
        drawCallback: function () {
            __currency_convert_recursively($('#mosque_donation_type_report'));
        }
    });

    var annualTable = $('#mosque_donation_annual_report').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.donations.reports.annual") }}',
            data: function (d) {
                return $.extend({}, d, getFilters());
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'year', name: 'year' },
            { data: 'donor_name', name: 'donor_name' },
            { data: 'donations_count', name: 'donations_count', orderable: false, searchable: false },
            { data: 'total_amount', name: 'total_amount', orderable: false, searchable: false },
            { data: 'zakat_amount', name: 'zakat_amount', orderable: false, searchable: false },
        ],
        drawCallback: function () {
            __currency_convert_recursively($('#mosque_donation_annual_report'));
        }
    });

    var receiptsTable = $('#mosque_donation_receipt_register').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.donations.reports.receipts") }}',
            data: function (d) {
                return $.extend({}, d, getFilters());
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'date', name: 'date' },
            { data: 'receipt_no', name: 'receipt_no' },
            { data: 'donor_name', name: 'donor_name' },
            { data: 'type', name: 'type' },
            { data: 'channel', name: 'channel' },
            { data: 'amount', name: 'amount', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
        drawCallback: function () {
            __currency_convert_recursively($('#mosque_donation_receipt_register'));
        }
    });

    donorTable.on('init.dt', function () {
        $('#mosque_donation_donor_report_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });
    typeTable.on('init.dt', function () {
        $('#mosque_donation_type_report_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });
    annualTable.on('init.dt', function () {
        $('#mosque_donation_annual_report_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });
    receiptsTable.on('init.dt', function () {
        $('#mosque_donation_receipt_register_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });

    // Ensure defaults also apply on BFCache restores (Back/Forward + some reload flows).
    window.addEventListener('pageshow', function () {
        resetDonationReportFiltersToDefault();
        if ($('#mdr_date_range').data('daterangepicker')) {
            var s = moment($('#mdr_start_date').val(), 'YYYY-MM-DD');
            var e = moment($('#mdr_end_date').val(), 'YYYY-MM-DD');
            $('#mdr_date_range').data('daterangepicker').setStartDate(s);
            $('#mdr_date_range').data('daterangepicker').setEndDate(e);
            $('#mdr_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
        }
        donorTable.ajax.reload();
        typeTable.ajax.reload();
        annualTable.ajax.reload();
        receiptsTable.ajax.reload();
        refreshZakatSummary();
    });

    $(document).on('change', '#mdr_type, #mdr_channel, #mdr_year', function () {
        donorTable.ajax.reload();
        typeTable.ajax.reload();
        annualTable.ajax.reload();
        receiptsTable.ajax.reload();
        refreshZakatSummary();
    });

    refreshZakatSummary();
});
</script>
@endsection
