<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.donors.update', $donor->id), 'method' => 'post', 'id' => 'mosque_donor_form']) !!}
        {!! Form::hidden('_method', 'PUT') !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.edit')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('name', __('user.name') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-user"></i></span>
                            {!! Form::text('name', $donor->name, ['class' => 'form-control', 'required', 'placeholder' => __('user.name')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('tax_id', 'Tax ID:') !!}
                        {!! Form::text('tax_id', $donor->tax_id, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('phone', __('contact.mobile') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-phone"></i></span>
                            {!! Form::text('phone', $donor->phone, ['class' => 'form-control', 'id' => 'mosque_donor_phone', 'placeholder' => __('contact.mobile')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('whatsapp_number', 'WhatsApp:') !!}
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-whatsapp"></i></span>
                            {!! Form::text('whatsapp_number', (!empty($donor->whatsapp_same_as_phone) ? $donor->phone : $donor->whatsapp_number), ['class' => 'form-control', 'id' => 'mosque_donor_whatsapp_number', 'placeholder' => __('contact.mobile')]) !!}
                        </div>
                        <div class="checkbox" style="margin-top:5px;">
                            <label style="margin:0;">
                                {!! Form::hidden('whatsapp_same_as_phone', 0) !!}
                                <input type="checkbox" id="mosque_donor_whatsapp_same" name="whatsapp_same_as_phone" value="1" {{ !empty($donor->whatsapp_same_as_phone) ? 'checked' : '' }}>
                                Same as mobile
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('email', __('business.email') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-envelope"></i></span>
                            {!! Form::email('email', $donor->email, ['class' => 'form-control', 'placeholder' => __('business.email')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('address', __('business.address') . ':') !!}
                        {!! Form::textarea('address', $donor->address, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('notes', $donor->notes, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script type="text/javascript">
    (function () {
        function syncDonorWhatsapp() {
            var same = $('#mosque_donor_whatsapp_same').is(':checked');
            $('#mosque_donor_whatsapp_number').prop('readonly', same);
            if (same) {
                $('#mosque_donor_whatsapp_number').val($('#mosque_donor_phone').val());
            }
        }
        $(document).on('change', '#mosque_donor_whatsapp_same', syncDonorWhatsapp);
        $(document).on('keyup', '#mosque_donor_phone', function () {
            if ($('#mosque_donor_whatsapp_same').is(':checked')) {
                $('#mosque_donor_whatsapp_number').val($(this).val());
            }
        });
        $(document).ready(syncDonorWhatsapp);
    })();
</script>
