@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Donors')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Donors</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-12 text-right">
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.donors.create') }}" data-container=".mosque_donor_modal">
                    <i class="fa fa-plus"></i> @lang('messages.add')
                </button>
                <button type="button" class="btn btn-default btn-modal" data-href="{{ route('mosque.donors.import') }}" data-container=".mosque_donor_import_modal">
                    <i class="fa fa-upload"></i> Import
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_donors_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('user.name')</th>
                        <th>@lang('contact.mobile')</th>
                        <th>WhatsApp</th>
                        <th>@lang('business.email')</th>
                        <th>Tax ID</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_donor_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_donor_import_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

    <div class="modal fade" id="mosque_donor_confirm_delete_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_donor_confirm_delete_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_donor_confirm_delete_modal_label">@lang('messages.delete')</h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:6px;">Permanent delete: removes this donor profile (only audit logs remain).</p>
                    <p>Type <strong>Confirm</strong> (case-sensitive) to delete.</p>
                    <div class="form-group">
                        <input type="text" class="form-control" id="mosque_donor_confirm_delete_input" placeholder="Confirm" autocomplete="off">
                        <input type="hidden" id="mosque_donor_confirm_delete_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_donor_confirm_delete_btn">@lang('messages.delete')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        if (window.__mosque_donors_dt_init) {
            return;
        }
        window.__mosque_donors_dt_init = true;

                var donors_table;
                if ($.fn.DataTable.isDataTable('#mosque_donors_table')) {
                    donors_table = $('#mosque_donors_table').DataTable();
                } else {
            donors_table = $('#mosque_donors_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route("mosque.donors.data") }}',
                dom: 'lBfrtip',
                buttons: [
                    { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                    { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                    { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                    { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                    { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
                ],
                    columns: [
                        { data: 'name', name: 'name' },
                        { data: 'phone', name: 'phone' },
                        { data: 'whatsapp_number', name: 'whatsapp_number', orderable: false, searchable: false },
                        { data: 'email', name: 'email' },
                        { data: 'tax_id', name: 'tax_id' },
                        { data: 'action', name: 'action', orderable: false, searchable: false }
                    ]
                });
                }

        donors_table.on('init.dt', function () {
            $('#mosque_donors_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).off('submit.mosque_donor_form').on('submit.mosque_donor_form', 'form#mosque_donor_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_donor_modal').modal('hide');
                        toastr.success(result.msg);
                        donors_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).off('submit.mosque_donor_import_form').on('submit.mosque_donor_import_form', 'form#mosque_donor_import_form', function (e) {
            e.preventDefault();
            var formEl = this;
            var formData = new FormData(formEl);

            $.ajax({
                method: 'POST',
                url: $(formEl).attr('action'),
                data: formData,
                contentType: false,
                processData: false,
                success: function (result) {
                    if (result.success) {
                        $('.mosque_donor_import_modal').modal('hide');
                        toastr.success(result.msg);
                        donors_table.ajax.reload();
                    } else {
                        toastr.error(result.msg || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).off('click.mosque_delete_donor').on('click.mosque_delete_donor', '.delete_mosque_donor', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $('#mosque_donor_confirm_delete_url').val(href);
            $('#mosque_donor_confirm_delete_input').val('');
            $('#mosque_donor_confirm_delete_modal').modal('show');
        });

        $('#mosque_donor_confirm_delete_btn').on('click', function () {
            var txt = ($('#mosque_donor_confirm_delete_input').val() || '').trim();
            if (txt !== 'Confirm') {
                toastr.error('Please type Confirm (case-sensitive).');
                return;
            }
            var href = $('#mosque_donor_confirm_delete_url').val();
            $.ajax({
                method: 'DELETE',
                url: href,
                data: { _token: '{{ csrf_token() }}' },
                success: function (result) {
                    if (result.success || result.ok) {
                        $('#mosque_donor_confirm_delete_modal').modal('hide');
                        toastr.success(result.msg || result.toast || '@lang("lang_v1.success")');
                        donors_table.ajax.reload();
                    } else {
                        toastr.error(result.msg || result.toast || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });
    });
</script>
@endsection
