<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.events.entries.store'), 'method' => 'post', 'id' => 'mosque_event_entry_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.add')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('event_id', 'Event:*') !!}
                        {!! Form::select('event_id', $events, null, ['class' => 'form-control', 'required', 'placeholder' => __('lang_v1.none')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('date', __('lang_v1.date') . ':*') !!}
                        {!! Form::date('date', \Carbon\Carbon::now()->format('Y-m-d'), ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('type', __('lang_v1.type') . ':*') !!}
                        {!! Form::select('type', ['income' => 'Income', 'expense' => 'Expense'], 'income', ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('amount', __('sale.total_amount') . ':*') !!}
                        {!! Form::number('amount', null, ['class' => 'form-control', 'step' => '0.01', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('note', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('note', null, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <p class="text-muted">This will also be added to Finance (source: event).</p>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

