@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_events'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_events')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs">
            <li class="active"><a href="#tab_events" data-toggle="tab">Events</a></li>
            <li><a href="#tab_entries" data-toggle="tab">Entries (Income/Expense)</a></li>
            <li><a href="#tab_reports" data-toggle="tab">@lang('mosque::mosque.menu_events_reports')</a></li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div class="tab-pane active" id="tab_events">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.events.events.create', [], false) }}" data-container=".mosque_event_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_events_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Type</th>
                                <th>Start</th>
                                <th>End</th>
                                <th>P/L</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_entries">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Event</label>
                            {!! Form::select('event_id', $events, null, ['class' => 'form-control', 'id' => 'me_event_id', 'placeholder' => __('lang_v1.all')]) !!}
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label>Type</label>
                            <select id="me_type" class="form-control">
                                <option value="">@lang('lang_v1.all')</option>
                                <option value="income">Income</option>
                                <option value="expense">Expense</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-7 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.events.entries.create', [], false) }}" data-container=".mosque_event_entry_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>

                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_event_entries_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Event</th>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Note</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_reports">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('lang_v1.start_date')</label>
                            <input type="date" id="mer_start_date" class="form-control" value="{{ now()->startOfMonth()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('lang_v1.end_date')</label>
                            <input type="date" id="mer_end_date" class="form-control" value="{{ now()->endOfMonth()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Event</label>
                            {!! Form::select('event_id', $events, null, ['class' => 'form-control', 'id' => 'mer_event_id', 'placeholder' => __('lang_v1.all')]) !!}
                            <p class="help-block">Used on Monthly P/L.</p>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Event Type</label>
                            <input type="text" id="mer_event_type" class="form-control" placeholder="optional">
                            <p class="help-block">Used on Event-wise summary.</p>
                        </div>
                    </div>
                </div>

                <ul class="nav nav-pills" style="margin-bottom:10px;">
                    <li class="active"><a href="#tab_reports_events" data-toggle="tab">Event-wise P/L</a></li>
                    <li><a href="#tab_reports_monthly" data-toggle="tab">Monthly P/L</a></li>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_reports_events">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_events_pl_report_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Event</th>
                                        <th>Type</th>
                                        <th>Start</th>
                                        <th>End</th>
                                        <th>Income</th>
                                        <th>Expense</th>
                                        <th>Net</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane" id="tab_reports_monthly">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_events_monthly_pl_report_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Month</th>
                                        <th>Income</th>
                                        <th>Expense</th>
                                        <th>Net</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endcomponent

    <div class="modal fade mosque_event_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_event_entry_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var events_table = $('#mosque_events_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.events.events.data", [], false) }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'type', name: 'type' },
                { data: 'start_date', name: 'start_date' },
                { data: 'end_date', name: 'end_date' },
                { data: 'pl', name: 'pl', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_events_table')); }
        });

        var entries_table = $('#mosque_event_entries_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.events.entries.data", [], false) }}',
                data: function (d) {
                    d.event_id = $('#me_event_id').val();
                    d.type = $('#me_type').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'event_name', name: 'event_name' },
                { data: 'date', name: 'date' },
                { data: 'type', name: 'type' },
                { data: 'amount', name: 'amount', orderable: false, searchable: false },
                { data: 'note', name: 'note' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_event_entries_table')); }
        });

        function getEventReportFilters() {
            return {
                start_date: $('#mer_start_date').val(),
                end_date: $('#mer_end_date').val(),
                event_id: $('#mer_event_id').val(),
                event_type: $('#mer_event_type').val(),
            };
        }

        var events_pl_report_table = $('#mosque_events_pl_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.events.reports.events", [], false) }}',
                data: function (d) { return $.extend({}, d, getEventReportFilters()); }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'type', name: 'type' },
                { data: 'start_date', name: 'start_date' },
                { data: 'end_date', name: 'end_date' },
                { data: 'income_total', name: 'income_total', orderable: false, searchable: false },
                { data: 'expense_total', name: 'expense_total', orderable: false, searchable: false },
                { data: 'net_total', name: 'net_total', orderable: false, searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_events_pl_report_table')); }
        });

        var events_monthly_pl_report_table = $('#mosque_events_monthly_pl_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.events.reports.monthly", [], false) }}',
                data: function (d) { return $.extend({}, d, getEventReportFilters()); }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'month_ym', name: 'month_ym' },
                { data: 'income_total', name: 'income_total', orderable: false, searchable: false },
                { data: 'expense_total', name: 'expense_total', orderable: false, searchable: false },
                { data: 'net_total', name: 'net_total', orderable: false, searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_events_monthly_pl_report_table')); }
        });

        $(document).on('change', '#me_event_id, #me_type', function () {
            entries_table.ajax.reload();
        });

        $(document).on('change', '#mer_start_date, #mer_end_date, #mer_event_id, #mer_event_type', function () {
            events_pl_report_table.ajax.reload();
            events_monthly_pl_report_table.ajax.reload();
        });

        function ajaxForm(selector, modalSelector, tables) {
            $(document).on('submit', selector, function (e) {
                e.preventDefault();
                var $form = $(this);
                $.ajax({
                    method: $form.find('input[name=_method]').val() || $form.attr('method'),
                    url: $form.attr('action'),
                    data: $form.serialize(),
                    success: function (result) {
                        if (result.success) {
                            $(modalSelector).modal('hide');
                            toastr.success(result.msg);
                            tables.forEach(function (t) { t.ajax.reload(); });
                        } else {
                            toastr.error(result.msg);
                        }
                    },
                    error: function () { toastr.error('@lang("messages.something_went_wrong")'); }
                });
            });
        }

        ajaxForm('form#mosque_event_form', '.mosque_event_modal', [events_table]);
        ajaxForm('form#mosque_event_entry_form', '.mosque_event_entry_modal', [entries_table, events_table]);

    });
</script>
@endsection
