<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Event Summary - {{ $event->name }} - #{{ $event->id }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { display:flex; justify-content: flex-end; gap: 8px; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; display:flex; justify-content: space-between; gap: 12px; align-items: center; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #ddd; padding: 8px 6px; text-align:left; font-size: 12px; vertical-align: top; }
        th { background: #f5f5f5; }
        .kpi { display:flex; gap: 12px; margin-top: 10px; }
        .kpi .box { flex:1; border:1px solid #ddd; border-radius:4px; padding:10px; }
        .amount { font-weight: bold; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;
        $logoFallbackUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try { $logoFallbackUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo); } catch (\Exception $e) { $logoFallbackUrl = null; }
        }
        $logoSrc = $logoDataUri ?? $logoFallbackUrl;
        $settings = $settings ?? [];
    @endphp

    <div class="header">
        <div>
            <h1>Event Summary (P/L)</h1>
            <div class="muted">{{ $headerName }} &nbsp;|&nbsp; Event: {{ $event->name }} &nbsp;|&nbsp; #{{ $event->id }}</div>
        </div>
        @if(!empty($logoSrc))
            <div><img src="{{ $logoSrc }}" alt="Logo" style="max-height:60px;"></div>
        @endif
    </div>

    <div class="muted">
        Type: {{ $event->type ?? '-' }}<br>
        Dates: {{ !empty($event->start_date) ? \Carbon\Carbon::parse($event->start_date)->format('Y-m-d') : '-' }}
        to
        {{ !empty($event->end_date) ? \Carbon\Carbon::parse($event->end_date)->format('Y-m-d') : '-' }}
    </div>

    <div class="kpi">
        <div class="box">
            <div class="muted">Income</div>
            <div class="amount">{{ \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($income, $settings) }}</div>
        </div>
        <div class="box">
            <div class="muted">Expense</div>
            <div class="amount">{{ \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($expense, $settings) }}</div>
        </div>
        <div class="box">
            <div class="muted">Net</div>
            <div class="amount">{{ \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($net, $settings) }}</div>
        </div>
    </div>

    <h3 style="margin-top:16px;">Entries</h3>
    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Type</th>
                <th>Amount</th>
                <th>Note</th>
            </tr>
        </thead>
        <tbody>
            @forelse($entries as $e)
                <tr>
                    <td>{{ !empty($e->date) ? \Carbon\Carbon::parse($e->date)->format('Y-m-d') : '-' }}</td>
                    <td>{{ ucfirst($e->type) }}</td>
                    <td>{{ \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($e->amount, $settings) }}</td>
                    <td>{!! nl2br(e($e->note ?? '')) !!}</td>
                </tr>
            @empty
                <tr><td colspan="4" class="muted">No entries found.</td></tr>
            @endforelse
        </tbody>
    </table>

    @if(!empty($profile) && !empty($profile->header_text))
        <div style="margin-top:12px;" class="muted">
            {!! nl2br(e($profile->header_text)) !!}
        </div>
    @endif
</body>
</html>
