<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Family Card - {{ $family->family_code ?: $family->id }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { text-align: right; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid th, .grid td { padding: 7px 6px; border: 1px solid #ddd; font-size: 12px; vertical-align: top; }
        .label { width: 180px; color: #333; font-weight: bold; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;
        $logoUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try {
                $logoUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo);
            } catch (\Exception $e) {
                $logoUrl = null;
            }
        }
    @endphp

    <div class="header">
        <div class="row" style="display:flex;justify-content:space-between;align-items:center;gap:12px;">
            <div>
                <h1 style="margin:0;">Family Card</h1>
                <div class="muted">
                    {{ $headerName }} &nbsp;|&nbsp; Family: {{ $family->family_code ?: $family->id }}
                </div>
            </div>
            @if(!empty($logoDataUri) || !empty($logoUrl))
                <div>
                    <img src="{{ $logoDataUri ?? $logoUrl }}" alt="Logo" style="max-height:60px;">
                </div>
            @endif
        </div>
    </div>

    <table class="grid" style="border:none;">
        <tr>
            <td class="label" style="border:none;">Family Code</td>
            <td style="border:none;">{{ $family->family_code ?: '-' }}</td>
        </tr>
        <tr>
            <td class="label" style="border:none;">Head</td>
            <td style="border:none;">{{ !empty($head) ? $head->name : '-' }}</td>
        </tr>
        <tr>
            <td class="label" style="border:none;">Address</td>
            <td style="border:none;">{!! nl2br(e($family->address ?? '')) ?: '-' !!}</td>
        </tr>
        <tr>
            <td class="label" style="border:none;">Notes</td>
            <td style="border:none;">{!! nl2br(e($family->notes ?? '')) ?: '-' !!}</td>
        </tr>
    </table>

    <h3 style="margin-top:16px;margin-bottom:8px;font-size:14px;">Family Members</h3>
    <table class="grid">
        <thead>
            <tr>
                <th style="width:50px;">#</th>
                <th>Name</th>
                <th style="width:130px;">Relation</th>
                <th style="width:140px;">Phone</th>
                <th style="width:120px;">Status</th>
            </tr>
        </thead>
        <tbody>
            @forelse($members as $index => $m)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $m->name ?? '' }}</td>
                    <td>
                        @php
                            $rel = trim((string) ($m->relation ?? ''));
                            if ($rel === '' && !empty($head) && (int) ($m->id ?? 0) === (int) ($head->id ?? 0)) {
                                $rel = 'Head';
                            }
                            if ($rel === '') {
                                $rel = 'Member';
                            }
                        @endphp
                        {{ $rel }}
                    </td>
                    <td>{{ $m->phone ?? '-' }}</td>
                    <td>{{ $m->status ?? '-' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="muted">No members linked.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>
