@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Family Codes')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Family Codes</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-12 text-right">
                <a href="{{ route('mosque.families') }}" class="btn btn-default">
                    <i class="fa fa-arrow-left"></i> Families
                </a>
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.families.codes.create') }}" data-container=".mosque_family_code_modal">
                    <i class="fa fa-plus"></i> @lang('messages.add')
                </button>
            </div>
        </div>

        <div class="table-responsive" style="margin-top:10px;">
            <table class="table table-bordered table-striped" id="mosque_family_codes_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Active</th>
                        <th>Description</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_family_code_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var codes_table = $('#mosque_family_codes_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.families.codes.data") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'code', name: 'code' },
                { data: 'active', name: 'active', orderable: false, searchable: false },
                { data: 'description', name: 'description', orderable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        codes_table.on('init.dt', function () {
            $('#mosque_family_codes_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('submit', 'form#mosque_family_code_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_family_code_modal').modal('hide');
                        toastr.success(result.msg);
                        codes_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.delete_mosque_family_code', function (e) {
            e.preventDefault();
            var href = $(this).data('href');

            swal({
                title: LANG.sure,
                icon: 'warning',
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        method: 'DELETE',
                        url: href,
                        data: { _token: '{{ csrf_token() }}' },
                        success: function (result) {
                            if (result.success) {
                                toastr.success(result.msg);
                                codes_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
    });
</script>
@endsection
