<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.families.store'), 'method' => 'post', 'id' => 'mosque_family_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.add')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('family_code', 'Family Code:') !!}
                        {!! Form::select('family_code', [], null, ['class' => 'form-control', 'id' => 'mosque_family_code', 'data-initial' => (!empty($suggestedFamilyCode) ? $suggestedFamilyCode : '')]) !!}
                        @if(!empty($lastFamilyCode))
                            <p class="help-block">Last family code: <strong>{{ $lastFamilyCode }}</strong></p>
                        @endif
                        <p class="help-block">
                            Need a new code? <a href="{{ route('mosque.families.codes') }}" target="_blank">Manage Family Codes</a>
                        </p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('head_member_id', 'Head Member:') !!}
                        {!! Form::select('head_member_id', $members, null, ['class' => 'form-control', 'id' => 'mosque_family_head_member_id', 'placeholder' => __('lang_v1.none')]) !!}
                        <p class="help-block">Search by member name/phone.</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('head_relation', 'Head Relation:') !!}
                        {!! Form::select('head_relation', $relationOptions ?? [], 'Head', ['class' => 'form-control']) !!}
                        <p class="help-block">Example: Father, Mother, Brother, Sister, etc.</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('address', __('business.address') . ':') !!}
                        {!! Form::textarea('address', null, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <hr>
                    <div class="row" style="margin-bottom:8px;">
                        <div class="col-sm-6">
                            <h4 style="margin:0;">Family Members</h4>
                            <p class="help-block" style="margin:0;">Add multiple members (Head is auto included if selected).</p>
                        </div>
                        <div class="col-sm-6 text-right">
                            <button type="button" class="btn btn-xs btn-default" id="mosque_add_family_member_row">
                                <i class="fa fa-plus"></i> Add member
                            </button>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered" id="mosque_family_members_table" style="margin-bottom:0;">
                            <thead>
                                <tr>
                                    <th style="width:55%;">Member</th>
                                    <th style="width:35%;">Relation</th>
                                    <th style="width:10%;">&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>

                    <script type="text/template" id="mosque_family_member_row_tpl">
                        <tr>
                            <td>
                                <select name="member_ids[]" class="form-control mosque_family_member_select" style="width:100%;"></select>
                            </td>
                            <td>
                                <select name="member_relations[]" class="form-control">
                                    @if(!empty($relationOptions))
                                        @foreach($relationOptions as $k => $v)
                                            <option value="{{ $k }}">{{ $v }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </td>
                            <td class="text-center">
                                <button type="button" class="btn btn-xs btn-danger mosque_remove_family_member_row"><i class="fa fa-times"></i></button>
                            </td>
                        </tr>
                    </script>

                    <div class="form-group">
                        {!! Form::label('notes', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('notes', null, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>
