@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Families')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Families</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Family Code</label>
                    <select id="mf_family_code" class="form-control" style="width:100%;"></select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Has Head</label>
                    <select id="mf_has_head" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="yes">Yes</option>
                        <option value="no">No</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-12 text-right">
                <a href="{{ route('mosque.families.reports') }}" class="btn btn-default">
                    <i class="fa fa-bar-chart"></i> @lang('mosque::mosque.menu_families_reports')
                </a>
                <a href="{{ route('mosque.families.codes') }}" class="btn btn-default">
                    <i class="fa fa-tags"></i> Family Codes
                </a>
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.families.create') }}" data-container=".mosque_family_modal">
                    <i class="fa fa-plus"></i> @lang('messages.add')
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_families_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Family Code</th>
                        <th>Head</th>
                        <th>Members</th>
                        <th>@lang('business.address')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_family_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        if ($('#mf_family_code').hasClass('select2-hidden-accessible')) {
            try { $('#mf_family_code').select2('destroy'); } catch (e) {}
        }

        $('#mf_family_code').select2({
            width: '100%',
            allowClear: true,
            placeholder: 'Search family code',
            minimumInputLength: 0,
            ajax: {
                url: '{{ route("mosque.families.codes.search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { q: params.term || '' };
                },
                processResults: function (data) {
                    return { results: (data && data.results) ? data.results : [] };
                },
                cache: true
            }
        });

        function initHeadMemberSelect($modal) {
            var $select = $modal.find('#mosque_family_head_member_id');
            if ($select.length === 0) {
                return;
            }

            var selectedVal = $select.val();
            var selectedText = null;
            if (selectedVal) {
                selectedText = $select.find('option:selected').text();
            }

            if ($select.hasClass('select2-hidden-accessible')) {
                try { $select.select2('destroy'); } catch (e) {}
            }

            $select.select2({
                width: '100%',
                allowClear: true,
                dropdownParent: $modal,
                placeholder: 'Search member',
                minimumInputLength: 0,
                ajax: {
                    url: '{{ route("mosque.members.search") }}',
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return { q: params.term || '' };
                    },
                    processResults: function (data) {
                        return { results: (data && data.results) ? data.results : [] };
                    },
                    cache: true
                }
            });

            if (selectedVal && selectedText) {
                var option = new Option(selectedText, selectedVal, true, true);
                $select.append(option).trigger('change');
            }
        }

        function initFamilyCodeSelect($modal) {
            var $sel = $modal.find('#mosque_family_code');
            if ($sel.length === 0) {
                return;
            }

            var initial = $sel.data('initial') || $sel.data('current') || '';
            var selectedVal = $sel.val() || initial || '';

            if ($sel.hasClass('select2-hidden-accessible')) {
                try { $sel.select2('destroy'); } catch (e) {}
            }

            $sel.select2({
                width: '100%',
                tags: true,
                allowClear: true,
                dropdownParent: $modal,
                placeholder: 'Search or type family code',
                minimumInputLength: 0,
                ajax: {
                    url: '{{ route("mosque.families.codes.search") }}',
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return { q: params.term || '' };
                    },
                    processResults: function (data) {
                        return { results: (data && data.results) ? data.results : [] };
                    },
                    cache: true
                }
            });

            if (selectedVal) {
                var option = new Option(selectedVal, selectedVal, true, true);
                $sel.append(option).trigger('change');
            }
        }

        function initFamilyMemberRowSelect($modal, $select) {
            var selectedVal = $select.val();
            var selectedText = null;
            if (selectedVal) {
                selectedText = $select.find('option:selected').text();
            }

            if ($select.hasClass('select2-hidden-accessible')) {
                try { $select.select2('destroy'); } catch (e) {}
            }

            $select.select2({
                width: '100%',
                allowClear: true,
                dropdownParent: $modal,
                placeholder: 'Search member',
                minimumInputLength: 0,
                ajax: {
                    url: '{{ route("mosque.members.search") }}',
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return { q: params.term || '' };
                    },
                    processResults: function (data) {
                        return { results: (data && data.results) ? data.results : [] };
                    },
                    cache: true
                }
            });

            if (selectedVal && selectedText) {
                var option = new Option(selectedText, selectedVal, true, true);
                $select.append(option).trigger('change');
            }
        }

        function initFamilyMembersSection($modal) {
            var $table = $modal.find('#mosque_family_members_table');
            if ($table.length === 0) {
                return;
            }

            $table.find('select.mosque_family_member_select').each(function () {
                initFamilyMemberRowSelect($modal, $(this));
            });

            var $btn = $modal.find('#mosque_add_family_member_row');
            if ($btn.data('bound')) {
                return;
            }
            $btn.data('bound', 1);

            $btn.on('click', function () {
                var tpl = $modal.find('#mosque_family_member_row_tpl').html();
                if (!tpl) {
                    return;
                }
                var $row = $(tpl);
                $table.find('tbody').append($row);
                initFamilyMemberRowSelect($modal, $row.find('select.mosque_family_member_select'));
            });

            $modal.on('click', '.mosque_remove_family_member_row', function () {
                $(this).closest('tr').remove();
            });
        }

        var families_table = $('#mosque_families_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.families.data") }}',
                data: function (d) {
                    d.family_code = $('#mf_family_code').val();
                    d.has_head = $('#mf_has_head').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'family_code', name: 'family_code' },
                { data: 'head', name: 'head', orderable: false, searchable: false },
                { data: 'members_count', name: 'members_count', orderable: false, searchable: false },
                { data: 'address', name: 'address', orderable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        families_table.on('init.dt', function () {
            $('#mosque_families_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('change', '#mf_family_code, #mf_has_head', function () {
            families_table.ajax.reload();
        });

        $(document).on('shown.bs.modal', '.mosque_family_modal', function () {
            var $modal = $(this);
            initFamilyCodeSelect($modal);
            initHeadMemberSelect($modal);
            initFamilyMembersSection($modal);
        });

        $(document).on('submit', 'form#mosque_family_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_family_modal').modal('hide');
                        toastr.success(result.msg);
                        families_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.delete_mosque_family', function (e) {
            e.preventDefault();
            var href = $(this).data('href');

            swal({
                title: LANG.sure,
                icon: 'warning',
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        method: 'DELETE',
                        url: href,
                        data: { _token: '{{ csrf_token() }}' },
                        success: function (result) {
                            if (result.success) {
                                toastr.success(result.msg);
                                families_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
    });
</script>
@endsection
