@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_families_reports'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_families_reports')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Family Code</label>
                    <select id="mfr_family_code" class="form-control" style="width:100%;"></select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Has Head</label>
                    <select id="mfr_has_head" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="yes">Yes</option>
                        <option value="no">No</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Head name</label>
                    <input type="text" id="mfr_head_search" class="form-control" placeholder="Search head name">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Member search</label>
                    <input type="text" id="mfr_member_search" class="form-control" placeholder="Search member name/phone">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Members min</label>
                    <input type="number" min="0" step="1" id="mfr_members_min" class="form-control" placeholder="0">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Members max</label>
                    <input type="number" min="0" step="1" id="mfr_members_max" class="form-control" placeholder="Any">
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_families_report_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Family Code</th>
                        <th>Head</th>
                        <th>Members</th>
                        <th>Members Details</th>
                        <th>@lang('business.address')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_family_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(document).ready(function () {
    $('#mfr_family_code').select2({
        width: '100%',
        tags: true,
        allowClear: true,
        placeholder: 'Search or type family code',
        minimumInputLength: 0,
        minimumResultsForSearch: 0,
        ajax: {
            url: '{{ route("mosque.families.codes.search") }}',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return { q: params.term || '' };
            },
            processResults: function (data) {
                return { results: (data && data.results) ? data.results : [] };
            },
            cache: true
        }
    });

    var table = $('#mosque_families_report_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.families.reports.data") }}',
            data: function (d) {
                d.has_head = $('#mfr_has_head').val();
                d.family_code = $('#mfr_family_code').val();
                d.head_search = $('#mfr_head_search').val();
                d.member_search = $('#mfr_member_search').val();
                d.members_min = $('#mfr_members_min').val();
                d.members_max = $('#mfr_members_max').val();
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'family_code', name: 'family_code' },
            { data: 'head_name', name: 'head_name' },
            { data: 'members_count', name: 'members_count', orderable: false, searchable: false },
            { data: 'members_details', name: 'members_details', orderable: false, searchable: false },
            { data: 'address', name: 'address', orderable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });

    table.on('init.dt', function () {
        $('#mosque_families_report_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });

    $(document).on('change', '#mfr_has_head, #mfr_family_code, #mfr_members_min, #mfr_members_max', function () {
        table.ajax.reload();
    });

    var reloadTimer = null;
    $(document).on('keyup', '#mfr_head_search, #mfr_member_search', function () {
        clearTimeout(reloadTimer);
        reloadTimer = setTimeout(function () {
            table.ajax.reload();
        }, 350);
    });
});
</script>
@endsection
