@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_bank_management'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_bank_management')</h1>
</section>

<section class="content">
    <style>
        .mbm-summary { margin-top: 8px; margin-bottom: 8px; }
        .mbm-summary .mbm-box { border-radius: 8px; padding: 10px 12px; font-weight: 800; border: 1px solid rgba(0,0,0,.06); }
        .mbm-summary .mbm-box small { display:block; font-weight: 700; opacity: .9; margin-bottom: 2px; }
        .mbm-summary .mbm-cash { background: #f8fafc; color: #0f172a; }
        .mbm-summary .mbm-bank { background: #e9f7ef; color: #0f5132; }
        .mbm-summary .mbm-net { background: #e7f1ff; color: #084298; }
    </style>

    @component('components.widget', ['class' => 'box-primary'])
        <div class="row mbm-summary">
            <div class="col-sm-4">
                <div class="mbm-box mbm-cash">
                    <small>@lang('mosque::mosque.bank_cash_balance')</small>
                    <span class="display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($bankSummary['cash_net_balance'] ?? 0) }}">{{ (float) ($bankSummary['cash_net_balance'] ?? 0) }}</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="mbm-box mbm-bank">
                    <small>@lang('mosque::mosque.bank_total_bank_wallets')</small>
                    <span class="display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($bankSummary['bank_wallet_total'] ?? 0) }}">{{ (float) ($bankSummary['bank_wallet_total'] ?? 0) }}</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="mbm-box mbm-net">
                    <small>@lang('mosque::mosque.bank_net_including_bank')</small>
                    <span class="display_currency" data-currency_symbol="true" data-orig-value="{{ (float) ($bankSummary['net_including_bank'] ?? 0) }}">{{ (float) ($bankSummary['net_including_bank'] ?? 0) }}</span>
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs">
            <li class="active"><a href="#tab_bank_wallets" data-toggle="tab">@lang('mosque::mosque.bank_menu_wallets')</a></li>
            <li><a href="#tab_bank_transfers" data-toggle="tab">@lang('mosque::mosque.bank_menu_transfers')</a></li>
            <li><a href="#tab_bank_cashouts" data-toggle="tab">@lang('mosque::mosque.bank_menu_cashouts')</a></li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div class="tab-pane active" id="tab_bank_wallets">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.finance.banks.create') }}" data-container=".mosque_bank_modal">
                            <i class="fa fa-plus"></i> @lang('mosque::mosque.bank_add_account')
                        </button>
                    </div>
                </div>
                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_bank_accounts_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>@lang('mosque::mosque.bank_bank_name')</th>
                                <th>@lang('mosque::mosque.bank_account_no')</th>
                                <th>@lang('mosque::mosque.bank_account_holder')</th>
                                <th>@lang('mosque::mosque.bank_wallet_balance')</th>
                                <th>@lang('lang_v1.status')</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_bank_transfers">
                <form id="mosque_net_to_bank_form">
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label>@lang('mosque::mosque.bank_bank_account') *</label>
                                <select name="bank_account_id" class="form-control" required>
                                    <option value="">@lang('lang_v1.please_select')</option>
                                    @foreach(($banks ?? []) as $id => $label)
                                        <option value="{{ $id }}">{{ $label }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label>@lang('mosque::mosque.bank_amount') *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label>@lang('lang_v1.date') *</label>
                                <input type="date" name="transfer_date" class="form-control" value="{{ now()->format('Y-m-d') }}" required>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label>@lang('lang_v1.note')</label>
                                <input type="text" name="note" class="form-control" placeholder="@lang('lang_v1.note')">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 text-right" style="margin-bottom:10px;">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-exchange"></i> @lang('mosque::mosque.bank_transfer_to_bank')</button>
                        </div>
                    </div>
                </form>

                <div class="row" style="margin-bottom:10px;">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('report.date_range')</label>
                            <input type="text" id="mbt_date_range" class="form-control" readonly autocomplete="off" placeholder="@lang('lang_v1.select_a_date_range')">
                            <input type="hidden" id="mbt_start_date" value="{{ now()->startOfYear()->format('Y-m-d') }}">
                            <input type="hidden" id="mbt_end_date" value="{{ now()->endOfYear()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('mosque::mosque.bank_bank_account')</label>
                            <select id="mbt_bank_account_id" class="form-control">
                                <option value="">@lang('lang_v1.all')</option>
                                @foreach(($banks ?? []) as $id => $label)
                                    <option value="{{ $id }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label>@lang('lang_v1.status')</label>
                            <select id="mbt_status" class="form-control">
                                <option value="">@lang('lang_v1.all')</option>
                                <option value="completed">@lang('lang_v1.completed')</option>
                                <option value="voided">@lang('lang_v1.voided')</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_net_bank_transfers_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>@lang('lang_v1.date')</th>
                                <th>@lang('mosque::mosque.bank_bank_account')</th>
                                <th>@lang('mosque::mosque.bank_amount')</th>
                                <th>@lang('lang_v1.note')</th>
                                <th>@lang('lang_v1.status')</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_bank_cashouts">
                <div class="row">
                    <div class="col-sm-12 text-right" style="margin-bottom:10px;">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.finance.cashouts.create') }}" data-container=".mosque_cashout_modal">
                            <i class="fa fa-plus"></i> @lang('mosque::mosque.bank_cashout_request')
                        </button>
                    </div>
                </div>

                <div class="row" style="margin-bottom:10px;">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>@lang('report.date_range')</label>
                            <input type="text" id="mco_date_range" class="form-control" readonly autocomplete="off" placeholder="@lang('lang_v1.select_a_date_range')">
                            <input type="hidden" id="mco_start_date" value="{{ now()->startOfYear()->format('Y-m-d') }}">
                            <input type="hidden" id="mco_end_date" value="{{ now()->endOfYear()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>@lang('mosque::mosque.bank_bank_account')</label>
                            <select id="mco_bank_account_id" class="form-control">
                                <option value="">@lang('lang_v1.all')</option>
                                @foreach(($banks ?? []) as $id => $label)
                                    <option value="{{ $id }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>@lang('lang_v1.status')</label>
                            <select id="mco_status" class="form-control">
                                <option value="">@lang('lang_v1.all')</option>
                                <option value="pending">@lang('lang_v1.pending')</option>
                                <option value="approved">@lang('lang_v1.approved')</option>
                                <option value="rejected">@lang('lang_v1.rejected')</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row" style="margin-bottom:10px;">
                    <div class="col-sm-12 text-right">
                        <strong>@lang('mosque::mosque.bank_total_cashout_amount'):</strong>
                        <span id="mco_total_amount" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_cashouts_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>@lang('lang_v1.date')</th>
                                <th>@lang('mosque::mosque.bank_bank_account')</th>
                                <th>@lang('mosque::mosque.bank_amount')</th>
                                <th>@lang('mosque::mosque.bank_reason')</th>
                                <th>@lang('lang_v1.status')</th>
                                <th>@lang('mosque::mosque.bank_attachment')</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    @endcomponent

    <div class="modal fade mosque_bank_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_cashout_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

    <div class="modal fade" id="mosque_cashout_reject_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_cashout_reject_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_cashout_reject_modal_label">@lang('mosque::mosque.bank_reject_request')</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.bank_reject_reason') <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="mosque_cashout_reject_reason" rows="3" placeholder="@lang('mosque::mosque.bank_reject_reason')"></textarea>
                        <input type="hidden" id="mosque_cashout_reject_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_cashout_reject_btn">@lang('messages.submit')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="mosque_cashout_confirm_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_cashout_confirm_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_cashout_confirm_modal_label">@lang('mosque::mosque.bank_confirm_action_title')</h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:8px;"><strong>@lang('mosque::mosque.bank_confirm_irreversible')</strong></p>
                    <p>@lang('mosque::mosque.bank_type_confirm_to_continue')</p>
                    <input type="text" class="form-control" id="mosque_cashout_confirm_input" autocomplete="off" placeholder="@lang('mosque::mosque.bank_type_confirm_placeholder')">
                    <input type="hidden" id="mosque_cashout_confirm_url" value="">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_cashout_confirm_btn" disabled>@lang('mosque::mosque.bank_btn_confirm')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script>
$(function () {
    // Wallets table
    var walletsTable = $('#mosque_bank_accounts_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{ route("mosque.finance.banks.data") }}',
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'bank_name', name: 'bank_name' },
            { data: 'account_no', name: 'account_no' },
            { data: 'account_holder', name: 'account_holder' },
            { data: 'wallet_balance', name: 'wallet_balance', orderable: false, searchable: false },
            { data: 'status', name: 'status', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
    });

    $(document).on('submit', 'form#mosque_bank_account_form', function (e) {
        e.preventDefault();
        var form = $(this);
        $.ajax({
            method: form.attr('method'),
            url: form.attr('action'),
            data: form.serialize(),
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    $('.mosque_bank_modal').modal('hide');
                    toastr.success(res.msg || LANG.success);
                    walletsTable.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () {
                toastr.error(LANG.something_went_wrong);
            }
        });
    });

    // Transfers
    function resetTransferFilters() {
        var s = moment().startOf('year');
        var e = moment().endOf('year');
        $('#mbt_start_date').val(s.format('YYYY-MM-DD'));
        $('#mbt_end_date').val(e.format('YYYY-MM-DD'));
        if ($('#mbt_date_range').length && typeof moment_date_format !== 'undefined') {
            $('#mbt_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
        }
    }
    resetTransferFilters();
    if (typeof dateRangeSettings !== 'undefined' && $('#mbt_date_range').length) {
        var start = moment($('#mbt_start_date').val(), 'YYYY-MM-DD');
        var end = moment($('#mbt_end_date').val(), 'YYYY-MM-DD');
        $('#mbt_date_range').daterangepicker(
            $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
            function (s, e) {
                $('#mbt_start_date').val(s.format('YYYY-MM-DD'));
                $('#mbt_end_date').val(e.format('YYYY-MM-DD'));
                $('#mbt_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                transfersTable.ajax.reload();
            }
        );
        $('#mbt_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
    }

    var transfersTable = $('#mosque_net_bank_transfers_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.finance.transfers.data") }}',
            data: function (d) {
                d.start_date = $('#mbt_start_date').val();
                d.end_date = $('#mbt_end_date').val();
                d.bank_account_id = $('#mbt_bank_account_id').val();
                d.status = $('#mbt_status').val();
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'transfer_date', name: 'transfer_date' },
            { data: 'bank', name: 'bank_name', orderable: false, searchable: true },
            { data: 'amount', name: 'amount', orderable: false, searchable: false },
            { data: 'note', name: 'note' },
            { data: 'status', name: 'status' },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
    });
    $('#mbt_bank_account_id, #mbt_status').on('change', function () { transfersTable.ajax.reload(); });
    $('#mosque_net_to_bank_form').on('submit', function (e) {
        e.preventDefault();
        $.ajax({
            method: 'POST',
            url: '{{ route("mosque.finance.transfers.store") }}',
            data: $(this).serialize(),
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    toastr.success(res.msg || LANG.success);
                    transfersTable.ajax.reload();
                    walletsTable.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () { toastr.error(LANG.something_went_wrong); }
        });
    });

    // Cashouts
    function resetCashoutFilters() {
        var s = moment().startOf('year');
        var e = moment().endOf('year');
        $('#mco_start_date').val(s.format('YYYY-MM-DD'));
        $('#mco_end_date').val(e.format('YYYY-MM-DD'));
        $('#mco_bank_account_id').val('');
        $('#mco_status').val('');
        if ($('#mco_date_range').length && typeof moment_date_format !== 'undefined') {
            $('#mco_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
        }
    }
    resetCashoutFilters();
    if (typeof dateRangeSettings !== 'undefined' && $('#mco_date_range').length) {
        var start2 = moment($('#mco_start_date').val(), 'YYYY-MM-DD');
        var end2 = moment($('#mco_end_date').val(), 'YYYY-MM-DD');
        $('#mco_date_range').daterangepicker(
            $.extend({}, dateRangeSettings, { startDate: start2, endDate: end2 }),
            function (s, e) {
                $('#mco_start_date').val(s.format('YYYY-MM-DD'));
                $('#mco_end_date').val(e.format('YYYY-MM-DD'));
                $('#mco_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                cashoutsTable.ajax.reload();
            }
        );
        $('#mco_date_range').val(start2.format(moment_date_format) + ' ~ ' + end2.format(moment_date_format));
    }

    var cashoutsTable = $('#mosque_cashouts_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.finance.cashouts.data") }}',
            data: function (d) {
                d.start_date = $('#mco_start_date').val();
                d.end_date = $('#mco_end_date').val();
                d.bank_account_id = $('#mco_bank_account_id').val();
                d.status = $('#mco_status').val();
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'request_date', name: 'request_date' },
            { data: 'bank', name: 'bank_name', orderable: false, searchable: true },
            { data: 'amount', name: 'amount', orderable: false, searchable: false },
            { data: 'reason', name: 'reason' },
            { data: 'status', name: 'status' },
            { data: 'attachment', name: 'attachment', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
    });
    cashoutsTable.on('xhr.dt', function (e, settings, json) {
        var total = parseFloat((json && json.total_amount) ? json.total_amount : 0) || 0;
        $('#mco_total_amount').attr('data-orig-value', total).text(total);
        __currency_convert_recursively($('.content'));
    });
    $('#mco_bank_account_id, #mco_status').on('change', function () { cashoutsTable.ajax.reload(); });

    var mosque_cashout_i18n = {
        confirm_action: "@lang('mosque::mosque.bank_confirm_action_title')",
        approve_cashout: "@lang('mosque::mosque.bank_approve_cashout')",
        approve: "@lang('mosque::mosque.bank_btn_approve')",
        confirm: "@lang('mosque::mosque.bank_btn_confirm')"
    };

    function openConfirm(url, title, btnText) {
        $('#mosque_cashout_confirm_modal_label').text(title || mosque_cashout_i18n.confirm_action);
        $('#mosque_cashout_confirm_url').val(url || '');
        $('#mosque_cashout_confirm_input').val('');
        $('#mosque_cashout_confirm_btn').prop('disabled', true).text(btnText || mosque_cashout_i18n.confirm);
        $('#mosque_cashout_confirm_modal').modal('show');
    }
    $(document).on('keyup change input', '#mosque_cashout_confirm_input', function () {
        var ok = String($(this).val() || '').trim().toUpperCase() === 'CONFIRM';
        $('#mosque_cashout_confirm_btn').prop('disabled', !ok);
    });
    $(document).on('click', '.mosque_cashout_approve', function (e) {
        e.preventDefault();
        openConfirm($(this).attr('data-href'), mosque_cashout_i18n.approve_cashout, mosque_cashout_i18n.approve);
    });
    $(document).on('click', '.mosque_cashout_reject', function (e) {
        e.preventDefault();
        $('#mosque_cashout_reject_url').val($(this).attr('data-href'));
        $('#mosque_cashout_reject_reason').val('');
        $('#mosque_cashout_reject_modal').modal('show');
    });
    $(document).on('click', '#mosque_cashout_confirm_btn', function () {
        var url = $('#mosque_cashout_confirm_url').val();
        if (!url) return;
        $('#mosque_cashout_confirm_btn').prop('disabled', true);
        $.ajax({
            method: 'POST',
            url: url,
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    toastr.success(res.msg || LANG.success);
                    $('#mosque_cashout_confirm_modal').modal('hide');
                    cashoutsTable.ajax.reload();
                    walletsTable.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                    $('#mosque_cashout_confirm_btn').prop('disabled', false);
                }
            },
            error: function () {
                toastr.error(LANG.something_went_wrong);
                $('#mosque_cashout_confirm_btn').prop('disabled', false);
            }
        });
    });
    $(document).on('click', '#mosque_cashout_reject_btn', function () {
        var url = $('#mosque_cashout_reject_url').val();
        var reason = $('#mosque_cashout_reject_reason').val();
        if (!url) return;
        $.ajax({
            method: 'POST',
            url: url,
            data: { reject_reason: reason },
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    toastr.success(res.msg || LANG.success);
                    $('#mosque_cashout_reject_modal').modal('hide');
                    cashoutsTable.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () { toastr.error(LANG.something_went_wrong); }
        });
    });

    $(document).on('submit', '#mosque_cashout_form', function (e) {
        e.preventDefault();
        var formEl = $(this)[0];
        var data = new FormData(formEl);
        $.ajax({
            method: 'POST',
            url: $(this).attr('action'),
            data: data,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    toastr.success(res.msg || LANG.success);
                    $('.mosque_cashout_modal').modal('hide');
                    cashoutsTable.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () { toastr.error(LANG.something_went_wrong); }
        });
    });

    // Ensure DataTables layout after switching tabs
    $('a[data-toggle="tab"]').on('shown.bs.tab', function () {
        try { walletsTable.columns.adjust(); } catch(e) {}
        try { transfersTable.columns.adjust(); } catch(e) {}
        try { cashoutsTable.columns.adjust(); } catch(e) {}
    });
});
</script>
@endsection
