<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.finance.banks.update', [$bank->id]), 'method' => 'put', 'id' => 'mosque_bank_account_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('mosque::mosque.bank_edit_account')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('bank_name', __('mosque::mosque.bank_bank_name') . ':*') !!}
                        {!! Form::text('bank_name', $bank->bank_name, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_no', __('mosque::mosque.bank_account_no') . ':*') !!}
                        {!! Form::text('account_no', $bank->account_no, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_holder', __('mosque::mosque.bank_account_holder') . ':') !!}
                        {!! Form::text('account_holder', $bank->account_holder, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group" style="margin-top:25px;">
                        <label>
                            {!! Form::checkbox('is_active', 1, (bool) $bank->is_active) !!} @lang('lang_v1.active')
                        </label>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('lang_v1.note') . ':') !!}
                        {!! Form::textarea('notes', $bank->notes, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

