@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.bank_menu_wallets'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.bank_menu_wallets')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row" style="margin-bottom:10px;">
            <div class="col-sm-12 text-right">
                <a href="{{ route('mosque.finance') }}" class="btn btn-default"><i class="fa fa-arrow-left"></i> @lang('messages.back')</a>
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.finance.banks.create') }}" data-container=".mosque_bank_modal">
                    <i class="fa fa-plus"></i> @lang('mosque::mosque.bank_add_account')
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_bank_accounts_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('mosque::mosque.bank_bank_name')</th>
                        <th>@lang('mosque::mosque.bank_account_no')</th>
                        <th>@lang('mosque::mosque.bank_account_holder')</th>
                        <th>@lang('mosque::mosque.bank_wallet_balance')</th>
                        <th>@lang('lang_v1.status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_bank_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script>
$(function () {
    var table = $('#mosque_bank_accounts_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{ route("mosque.finance.banks.data") }}',
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'bank_name', name: 'bank_name' },
            { data: 'account_no', name: 'account_no' },
            { data: 'account_holder', name: 'account_holder' },
            { data: 'wallet_balance', name: 'wallet_balance', orderable: false, searchable: false },
            { data: 'status', name: 'status', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
    });

    $(document).on('submit', 'form#mosque_bank_account_form', function (e) {
        e.preventDefault();
        var form = $(this);
        $.ajax({
            method: form.attr('method'),
            url: form.attr('action'),
            data: form.serialize(),
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    $('.mosque_bank_modal').modal('hide');
                    toastr.success(res.msg || LANG.success);
                    table.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () {
                toastr.error(LANG.something_went_wrong);
            }
        });
    });
});
</script>
@endsection
