<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.finance.cashouts.store'), 'method' => 'post', 'id' => 'mosque_cashout_form', 'enctype' => 'multipart/form-data']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('mosque::mosque.bank_cashout_request')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('bank_account_id', __('mosque::mosque.bank_bank_account') . ':*') !!}
                        {!! Form::select('bank_account_id', $banks ?? [], null, ['class' => 'form-control', 'required', 'placeholder' => __('lang_v1.please_select')]) !!}
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        {!! Form::label('amount', __('mosque::mosque.bank_amount') . ':*') !!}
                        {!! Form::number('amount', null, ['class' => 'form-control', 'required', 'step' => '0.01', 'min' => '0.01']) !!}
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        {!! Form::label('request_date', __('lang_v1.date') . ':*') !!}
                        {!! Form::date('request_date', now()->format('Y-m-d'), ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('reason', __('mosque::mosque.bank_reason') . ':*') !!}
                        {!! Form::textarea('reason', null, ['class' => 'form-control', 'rows' => 3, 'required', 'placeholder' => __('mosque::mosque.bank_reason')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('attachment', __('mosque::mosque.bank_attachment') . ':') !!}
                        {!! Form::file('attachment', ['class' => 'form-control']) !!}
                        <p class="help-block">@lang('mosque::mosque.bank_attachment_help')</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
$(function () {
    $('#mosque_cashout_form').on('submit', function (e) {
        e.preventDefault();
        var form = $(this)[0];
        var data = new FormData(form);
        $.ajax({
            method: 'POST',
            url: $(this).attr('action'),
            data: data,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    $('.mosque_cashout_modal').modal('hide');
                    toastr.success(res.msg || LANG.success);
                    if ($.fn.dataTable.isDataTable('#mosque_cashouts_table')) {
                        $('#mosque_cashouts_table').DataTable().ajax.reload();
                    }
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () {
                toastr.error(LANG.something_went_wrong);
            }
        });
    });
});
</script>

