@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.bank_menu_cashouts'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.bank_menu_cashouts')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-12 text-right" style="margin-bottom:10px;">
                <a href="{{ route('mosque.finance') }}" class="btn btn-default"><i class="fa fa-arrow-left"></i> @lang('messages.back')</a>
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.finance.cashouts.create') }}" data-container=".mosque_cashout_modal">
                    <i class="fa fa-plus"></i> @lang('mosque::mosque.bank_cashout_request')
                </button>
            </div>
        </div>

        <div class="row" style="margin-bottom:10px;">
            <div class="col-sm-4">
                <div class="form-group">
                    <label>@lang('report.date_range')</label>
                    <input type="text" id="mco_date_range" class="form-control" readonly autocomplete="off" placeholder="@lang('lang_v1.select_a_date_range')">
                    <input type="hidden" id="mco_start_date" value="{{ now()->startOfYear()->format('Y-m-d') }}">
                    <input type="hidden" id="mco_end_date" value="{{ now()->endOfYear()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-4">
                <div class="form-group">
                    <label>@lang('mosque::mosque.bank_bank_account')</label>
                    <select id="mco_bank_account_id" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        @foreach(($banks ?? []) as $id => $label)
                            <option value="{{ $id }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="form-group">
                    <label>@lang('lang_v1.status')</label>
                    <select id="mco_status" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="pending">@lang('lang_v1.pending')</option>
                        <option value="approved">@lang('lang_v1.approved')</option>
                        <option value="rejected">@lang('lang_v1.rejected')</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="row" style="margin-bottom:10px;">
            <div class="col-sm-12 text-right">
                <strong>@lang('mosque::mosque.bank_total_cashout_amount'):</strong>
                <span id="mco_total_amount" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_cashouts_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('lang_v1.date')</th>
                        <th>@lang('mosque::mosque.bank_bank_account')</th>
                        <th>@lang('mosque::mosque.bank_amount')</th>
                        <th>@lang('mosque::mosque.bank_reason')</th>
                        <th>@lang('lang_v1.status')</th>
                        <th>@lang('mosque::mosque.bank_attachment')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_cashout_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

    <div class="modal fade" id="mosque_cashout_reject_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_cashout_reject_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_cashout_reject_modal_label">@lang('mosque::mosque.bank_reject_request')</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.bank_reject_reason') <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="mosque_cashout_reject_reason" rows="3" placeholder="@lang('mosque::mosque.bank_reject_reason')"></textarea>
                        <input type="hidden" id="mosque_cashout_reject_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_cashout_reject_btn">@lang('messages.submit')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="mosque_cashout_confirm_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_cashout_confirm_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_cashout_confirm_modal_label">@lang('mosque::mosque.bank_confirm_action_title')</h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:8px;"><strong>@lang('mosque::mosque.bank_confirm_irreversible')</strong></p>
                    <p>@lang('mosque::mosque.bank_type_confirm_to_continue')</p>
                    <input type="text" class="form-control" id="mosque_cashout_confirm_input" autocomplete="off" placeholder="@lang('mosque::mosque.bank_type_confirm_placeholder')">
                    <input type="hidden" id="mosque_cashout_confirm_url" value="">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_cashout_confirm_btn" disabled>@lang('mosque::mosque.bank_btn_confirm')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script>
$(function () {
    function resetCashoutFilters() {
        var s = moment().startOf('year');
        var e = moment().endOf('year');
        $('#mco_start_date').val(s.format('YYYY-MM-DD'));
        $('#mco_end_date').val(e.format('YYYY-MM-DD'));
        $('#mco_bank_account_id').val('');
        $('#mco_status').val('');
        if ($('#mco_date_range').length && typeof moment_date_format !== 'undefined') {
            $('#mco_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
        }
    }
    resetCashoutFilters();

    if (typeof dateRangeSettings !== 'undefined' && $('#mco_date_range').length) {
        var start = moment($('#mco_start_date').val(), 'YYYY-MM-DD');
        var end = moment($('#mco_end_date').val(), 'YYYY-MM-DD');
        $('#mco_date_range').daterangepicker(
            $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
            function (s, e) {
                $('#mco_start_date').val(s.format('YYYY-MM-DD'));
                $('#mco_end_date').val(e.format('YYYY-MM-DD'));
                $('#mco_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                table.ajax.reload();
            }
        );
        $('#mco_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
    }

    var table = $('#mosque_cashouts_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.finance.cashouts.data") }}',
            data: function (d) {
                d.start_date = $('#mco_start_date').val();
                d.end_date = $('#mco_end_date').val();
                d.bank_account_id = $('#mco_bank_account_id').val();
                d.status = $('#mco_status').val();
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'request_date', name: 'request_date' },
            { data: 'bank', name: 'bank_name', orderable: false, searchable: true },
            { data: 'amount', name: 'amount', orderable: false, searchable: false },
            { data: 'reason', name: 'reason' },
            { data: 'status', name: 'status' },
            { data: 'attachment', name: 'attachment', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
        drawCallback: function () {
            __currency_convert_recursively($('#mosque_cashouts_table'));
        }
    });

    $('#mosque_cashouts_table').on('xhr.dt', function (e, settings, json) {
        var total = parseFloat((json && json.total_amount) ? json.total_amount : 0) || 0;
        $('#mco_total_amount').attr('data-orig-value', total).text(total);
        __currency_convert_recursively($('.content'));
    });

    $('#mco_bank_account_id, #mco_status').on('change', function () {
        table.ajax.reload();
    });

    var mosque_cashout_i18n = {
        confirm_action: "@lang('mosque::mosque.bank_confirm_action_title')",
        approve_cashout: "@lang('mosque::mosque.bank_approve_cashout')",
        approve: "@lang('mosque::mosque.bank_btn_approve')",
        confirm: "@lang('mosque::mosque.bank_btn_confirm')"
    };

    function openConfirm(url, title, btnText) {
        $('#mosque_cashout_confirm_modal_label').text(title || mosque_cashout_i18n.confirm_action);
        $('#mosque_cashout_confirm_url').val(url || '');
        $('#mosque_cashout_confirm_input').val('');
        $('#mosque_cashout_confirm_btn').prop('disabled', true).text(btnText || mosque_cashout_i18n.confirm);
        $('#mosque_cashout_confirm_modal').modal('show');
    }

    $(document).on('keyup change input', '#mosque_cashout_confirm_input', function () {
        var ok = String($(this).val() || '').trim().toUpperCase() === 'CONFIRM';
        $('#mosque_cashout_confirm_btn').prop('disabled', !ok);
    });

    $(document).on('click', '.mosque_cashout_approve', function (e) {
        e.preventDefault();
        var url = $(this).attr('data-href');
        openConfirm(url, mosque_cashout_i18n.approve_cashout, mosque_cashout_i18n.approve);
    });

    $(document).on('click', '.mosque_cashout_reject', function (e) {
        e.preventDefault();
        var url = $(this).attr('data-href');
        $('#mosque_cashout_reject_url').val(url);
        $('#mosque_cashout_reject_reason').val('');
        $('#mosque_cashout_reject_modal').modal('show');
    });

    $(document).on('click', '#mosque_cashout_confirm_btn', function () {
        var url = $('#mosque_cashout_confirm_url').val();
        if (!url) return;
        $('#mosque_cashout_confirm_btn').prop('disabled', true);
        $.ajax({
            method: 'POST',
            url: url,
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    toastr.success(res.msg || LANG.success);
                    $('#mosque_cashout_confirm_modal').modal('hide');
                    table.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                    $('#mosque_cashout_confirm_btn').prop('disabled', false);
                }
            },
            error: function () {
                toastr.error(LANG.something_went_wrong);
                $('#mosque_cashout_confirm_btn').prop('disabled', false);
            }
        });
    });

    $(document).on('click', '#mosque_cashout_reject_btn', function () {
        var url = $('#mosque_cashout_reject_url').val();
        var reason = $('#mosque_cashout_reject_reason').val();
        if (!url) return;
        $.ajax({
            method: 'POST',
            url: url,
            data: { reject_reason: reason },
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    toastr.success(res.msg || LANG.success);
                    $('#mosque_cashout_reject_modal').modal('hide');
                    table.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () {
                toastr.error(LANG.something_went_wrong);
            }
        });
    });

    $(document).on('submit', '#mosque_cashout_form', function (e) {
        e.preventDefault();
        var formEl = $(this)[0];
        var data = new FormData(formEl);
        $.ajax({
            method: 'POST',
            url: $(this).attr('action'),
            data: data,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    toastr.success(res.msg || LANG.success);
                    $('.mosque_cashout_modal').modal('hide');
                    table.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () {
                toastr.error(LANG.something_went_wrong);
            }
        });
    });
});
</script>
@endsection
