<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@lang('mosque::mosque.bank_cashout_final_receipt') - {{ $cashout->request_no ?? $cashout->id }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { text-align: right; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .subtle { color: #444; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid td { padding: 7px 6px; vertical-align: top; }
        .label { width: 180px; color: #333; font-weight: bold; }
        .box { border: 1px solid #ddd; padding: 10px; border-radius: 4px; margin-top: 12px; font-size: 12px; }
        .section-title { font-weight: bold; font-size: 13px; margin: 0 0 6px 0; }
        .sig-row { margin-top: 18px; display: flex; justify-content: center; }
        .sig { width: 320px; text-align: center; }
        .sig .line { border-top: 1px solid #111; margin-top: 36px; padding-top: 4px; font-size: 12px; font-weight: bold; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">@lang('messages.print')</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? (string) $profile->name : $businessName;
        $mosqueAddress = !empty($profile) && !empty($profile->address) ? (string) $profile->address : '';
        $generatedOn = now()->format('Y-m-d H:i');
        $requestNo = (string) ($cashout->request_no ?? $cashout->id);
        $bankLabel = trim((string) (($bank?->bank_name ?? '').' - '.($bank?->account_no ?? '')));
        $amountFormatted = \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney((float) ($cashout->amount ?? 0), $settings ?? []);
        $approvedOn = !empty($cashout->approved_at) ? \Carbon\Carbon::parse($cashout->approved_at)->format('Y-m-d H:i') : '-';
        $requestedOn = !empty($cashout->requested_at) ? \Carbon\Carbon::parse($cashout->requested_at)->format('Y-m-d H:i') : '-';
    @endphp

    <div class="header">
        <div class="row" style="display:flex;justify-content:space-between;align-items:center;gap:12px;">
            <div>
                <h1 style="margin:0;">@lang('mosque::mosque.bank_cashout_final_receipt')</h1>
                <div class="muted">
                    {{ $headerName }} &nbsp;|&nbsp; Request: {{ $requestNo }}
                </div>
                @if(!empty($mosqueAddress))
                    <div class="subtle">{!! nl2br(e($mosqueAddress)) !!}</div>
                @endif
                <div class="muted">@lang('mosque::mosque.bank_computer_generated_receipt')</div>
            </div>
            @if(!empty($logoDataUri))
                <div>
                    <img src="{{ $logoDataUri }}" alt="Logo" style="max-height:60px;">
                </div>
            @endif
        </div>
    </div>

    <table class="grid">
        <tr>
            <td class="label">@lang('mosque::mosque.bank_generated_on')</td>
            <td>{{ $generatedOn }}</td>
        </tr>
        <tr>
            <td class="label">@lang('lang_v1.status')</td>
            <td>{{ ucfirst((string) ($cashout->status ?? 'approved')) }}</td>
        </tr>
        <tr>
            <td class="label">@lang('lang_v1.requested_on')</td>
            <td>{{ $requestedOn }}</td>
        </tr>
        <tr>
            <td class="label">@lang('lang_v1.approved_on')</td>
            <td>{{ $approvedOn }}</td>
        </tr>
        <tr>
            <td class="label">@lang('mosque::mosque.bank_request_date')</td>
            <td>{{ !empty($cashout->request_date) ? \Carbon\Carbon::parse($cashout->request_date)->format('Y-m-d') : '-' }}</td>
        </tr>
        <tr>
            <td class="label">@lang('mosque::mosque.bank_bank_account')</td>
            <td>{{ $bankLabel !== ' - ' ? $bankLabel : '-' }}</td>
        </tr>
        <tr>
            <td class="label">@lang('mosque::mosque.bank_amount')</td>
            <td><strong>{{ $amountFormatted }}</strong></td>
        </tr>
    </table>

    <div class="box">
        <div class="section-title">@lang('mosque::mosque.bank_reason')</div>
        <div style="white-space:pre-wrap;">{{ (string) ($cashout->reason ?? '') }}</div>
    </div>

    <div class="sig-row">
        <div class="sig">
            <div class="line">@lang('mosque::mosque.bank_authorised_signature')</div>
        </div>
    </div>
</body>
</html>
