@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Finance Categories')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Finance Categories</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('lang_v1.type')</label>
                    <select id="mfc_type" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="income">Income</option>
                        <option value="expense">Expense</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-9 text-right">
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.finance.categories.create') }}" data-container=".mosque_category_modal">
                    <i class="fa fa-plus"></i> @lang('messages.add')
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_finance_categories_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('lang_v1.type')</th>
                        <th>@lang('product.category')</th>
                        <th>@lang('lang_v1.is_active')</th>
                        <th>@lang('lang_v1.position')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_category_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

    <div class="modal fade" id="mosque_category_confirm_delete_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_category_confirm_delete_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_category_confirm_delete_modal_label">@lang('messages.delete')</h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:6px;">Permanent delete: removes this category. This will not remain in any reports (only audit logs remain).</p>
                    <p>Type <strong>Confirm</strong> (case-sensitive) to delete.</p>
                    <div class="form-group">
                        <input type="text" class="form-control" id="mosque_category_confirm_delete_input" placeholder="Confirm" autocomplete="off">
                        <input type="hidden" id="mosque_category_confirm_delete_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_category_confirm_delete_btn">@lang('messages.delete')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var categories_table = $('#mosque_finance_categories_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.finance.categories.data") }}',
                data: function (d) {
                    d.type = $('#mfc_type').val();
                }
            },
            columns: [
                { data: 'type', name: 'type' },
                { data: 'name', name: 'name' },
                { data: 'active', name: 'active', orderable: false, searchable: false },
                { data: 'sort_order', name: 'sort_order' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            order: [[3, 'asc']],
        });

        $(document).on('change', '#mfc_type', function () {
            categories_table.ajax.reload();
        });

        $(document).on('submit', 'form#mosque_finance_category_form', function (e) {
            e.preventDefault();
            var $form = $(this);

            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_category_modal').modal('hide');
                        toastr.success(result.msg);
                        categories_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.delete_mosque_category', function (e) {
            e.preventDefault();
            var href = $(this).data('href');

            $('#mosque_category_confirm_delete_url').val(href);
            $('#mosque_category_confirm_delete_input').val('');
            $('#mosque_category_confirm_delete_modal').modal('show');
        });

        $('#mosque_category_confirm_delete_btn').on('click', function () {
            var txt = ($('#mosque_category_confirm_delete_input').val() || '').trim();
            if (txt !== 'Confirm' && txt !== 'CONFIRM') {
                toastr.error('Please type Confirm (case-sensitive).');
                return;
            }
            var href = $('#mosque_category_confirm_delete_url').val();
            $.ajax({
                method: 'DELETE',
                url: href,
                data: { _token: '{{ csrf_token() }}' },
                success: function (result) {
                    if (result.success || result.ok) {
                        $('#mosque_category_confirm_delete_modal').modal('hide');
                        toastr.success(result.msg || result.toast || '@lang("lang_v1.success")');
                        categories_table.ajax.reload();
                    } else {
                        toastr.error(result.msg || result.toast || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });
    });
</script>
@endsection
