@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . ($title ?? 'Day Book'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ $title ?? 'Day Book' }}</h1>
    <a href="{{ route('mosque.finance') }}" class="btn btn-default pull-right" style="margin-top:-34px;">
        <i class="fa fa-arrow-left"></i> @lang('messages.back')
    </a>
</section>

<section class="content">
    <style>
        .mf-summary { margin-top: 6px; }
        .mf-box { border-radius: 4px; padding: 10px 12px; font-weight: 700; border: 1px solid rgba(0,0,0,.06); }
        .mf-box small { display:block; font-weight: 800; opacity: .95; }
        .mf-summary .mf-open { background: #f1f3f5; color: #212529; }
        .mf-summary .mf-close { background: #e7f1ff; color: #084298; }
        .mf-summary .mf-net { background: #e9f7ef; color: #0f5132; }
        .mf-summary .display_currency { font-weight: 800; }
    </style>

    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3" style="display:none;">
                <div class="form-group">
                    <label>@lang('lang_v1.start_date')</label>
                    <input type="date" id="mdb_start_date" class="form-control" value="{{ now()->startOfMonth()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-3" style="display:none;">
                <div class="form-group">
                    <label>@lang('lang_v1.end_date')</label>
                    <input type="date" id="mdb_end_date" class="form-control" value="{{ now()->endOfMonth()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-6">
                <div class="form-group">
                    <label>@lang('report.date_range')</label>
                    <input type="text" id="mdb_date_range" class="form-control" readonly autocomplete="off" placeholder="@lang('lang_v1.select_a_date_range')">
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('lang_v1.source')</label>
                    <select id="mdb_source" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="module">Module</option>
                        <option value="core_sale">Core Sale</option>
                        <option value="core_purchase">Core Purchase</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('lang_v1.type')</label>
                    <select id="mdb_type" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="income">Income</option>
                        <option value="expense">Expense</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>&nbsp;</label>
                    <div class="text-muted" style="padding-top: 8px;">&nbsp;</div>
                </div>
            </div>
        </div>

        <div class="row mf-summary">
            <div class="col-sm-4">
                <div class="mf-box mf-open">
                    <small>Opening Balance</small>
                    <span id="mdb_opening" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="mf-box mf-close">
                    <small>Closing Balance</small>
                    <span id="mdb_closing" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="mf-box mf-net">
                    <small>Net (Period)</small>
                    <span id="mdb_net" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_day_book_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Income</th>
                        <th>Expense</th>
                        <th>Net</th>
                        <th>Running Balance</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
        <div class="text-right text-muted" id="mosque_day_book_table_count" style="margin-top:6px;"></div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(document).ready(function () {
    var presetSource = @json($presetSource);
    if (presetSource) {
        $('#mdb_source').val(presetSource).prop('disabled', true);
    }

    // Force defaults on reload (avoid browser restoring old values).
    function resetFiltersToDefault() {
        var s = moment().startOf('year');
        var e = moment().endOf('year');
        $('#mdb_start_date').val(s.format('YYYY-MM-DD'));
        $('#mdb_end_date').val(e.format('YYYY-MM-DD'));
        if (!presetSource) {
            $('#mdb_source').val('');
        }
        $('#mdb_type').val('');
        if ($('#mdb_date_range').length && typeof moment_date_format !== 'undefined') {
            $('#mdb_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
        }
    }
    resetFiltersToDefault();

    // Date range filter (like Finance table)
    if (typeof dateRangeSettings !== 'undefined' && $('#mdb_date_range').length) {
        var start = moment($('#mdb_start_date').val(), 'YYYY-MM-DD');
        var end = moment($('#mdb_end_date').val(), 'YYYY-MM-DD');
        $('#mdb_date_range').daterangepicker(
            $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
            function (s, e) {
                $('#mdb_start_date').val(s.format('YYYY-MM-DD'));
                $('#mdb_end_date').val(e.format('YYYY-MM-DD'));
                $('#mdb_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                refresh();
            }
        );
        $('#mdb_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
        $('#mdb_date_range').on('cancel.daterangepicker', function () {
            resetFiltersToDefault();
            if ($('#mdb_date_range').data('daterangepicker')) {
                var s = moment($('#mdb_start_date').val(), 'YYYY-MM-DD');
                var e = moment($('#mdb_end_date').val(), 'YYYY-MM-DD');
                $('#mdb_date_range').data('daterangepicker').setStartDate(s);
                $('#mdb_date_range').data('daterangepicker').setEndDate(e);
            }
            refresh();
        });
    }

    function getFilters() {
        return {
            start_date: $('#mdb_start_date').val(),
            end_date: $('#mdb_end_date').val(),
            source: $('#mdb_source').val(),
            type: $('#mdb_type').val(),
        };
    }

    function render(rows, opening) {
        var $tbody = $('#mosque_day_book_table tbody');
        $tbody.empty();

        var netSum = 0;
        var closing = opening;

        (rows || []).forEach(function (r) {
            var income = parseFloat(r.income || 0);
            var expense = parseFloat(r.expense || 0);
            var net = parseFloat(r.net || 0);
            var balance = parseFloat(r.balance || 0);
            netSum += net;
            closing = balance;

            $tbody.append(
                '<tr>' +
                    '<td>' + r.date + '</td>' +
                    '<td><span class="display_currency" data-currency_symbol="true" data-orig-value="' + income + '">' + income + '</span></td>' +
                    '<td><span class="display_currency" data-currency_symbol="true" data-orig-value="' + expense + '">' + expense + '</span></td>' +
                    '<td><span class="display_currency" data-currency_symbol="true" data-orig-value="' + net + '">' + net + '</span></td>' +
                    '<td><span class="display_currency" data-currency_symbol="true" data-orig-value="' + balance + '">' + balance + '</span></td>' +
                '</tr>'
            );
        });

        $('#mdb_opening').attr('data-orig-value', opening).text(opening);
        $('#mdb_closing').attr('data-orig-value', closing).text(closing);
        $('#mdb_net').attr('data-orig-value', netSum).text(netSum);
        __currency_convert_recursively($('.content'));
    }

    var dt = null;

    function refresh() {
        $.ajax({
            method: 'GET',
            url: presetSource ? '{{ route("mosque.finance.cash_book.data") }}' : '{{ route("mosque.finance.day_book.data") }}',
            data: getFilters(),
            success: function (res) {
                if (!res || !res.success) return;
                render(res.rows, parseFloat(res.opening_balance || 0));

                if (dt) {
                    dt.destroy();
                }
                dt = $('#mosque_day_book_table').DataTable({
                    dom: 'lBfrtip',
                    buttons: [
                        { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                        { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                        { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                        { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                        { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
                    ],
                    order: [[0, 'asc']],
                    drawCallback: function () {
                        var info = dt ? dt.page.info() : null;
                        if (info) {
                            $('#mosque_day_book_table_count').text('Total rows: ' + info.recordsDisplay);
                        }
                    }
                });
                $('#mosque_day_book_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
                var info = dt ? dt.page.info() : null;
                if (info) {
                    $('#mosque_day_book_table_count').text('Total rows: ' + info.recordsDisplay);
                }
            }
        });
    }

    $(document).on('change', '#mdb_start_date, #mdb_end_date, #mdb_source, #mdb_type', function () {
        refresh();
    });

    window.addEventListener('pageshow', function () {
        resetFiltersToDefault();
        if ($('#mdb_date_range').data('daterangepicker')) {
            var s = moment($('#mdb_start_date').val(), 'YYYY-MM-DD');
            var e = moment($('#mdb_end_date').val(), 'YYYY-MM-DD');
            $('#mdb_date_range').data('daterangepicker').setStartDate(s);
            $('#mdb_date_range').data('daterangepicker').setEndDate(e);
            $('#mdb_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
        }
        refresh();
    });

    refresh();
});
</script>
@endsection
