<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.finance.entries.store'), 'method' => 'post', 'id' => 'mosque_finance_entry_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Add {{ ucfirst($type) }}</h4>
        </div>
        <div class="modal-body">
            {!! Form::hidden('type', $type) !!}
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('entry_date', __('lang_v1.date') . ':*') !!}
                        {!! Form::date('entry_date', \Carbon\Carbon::now()->format('Y-m-d'), ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('amount', __('sale.total_amount') . ':*') !!}
                        {!! Form::number('amount', null, ['class' => 'form-control', 'step' => '0.01', 'required']) !!}
                    </div>
                </div>

                <div class="col-sm-8">
                    <div class="form-group">
                        {!! Form::label('category_id', __('product.category') . ':*') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control', 'placeholder' => __('lang_v1.please_select'), 'required']) !!}
                    </div>
                </div>

                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('note', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('note', null, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>
