@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_finance'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_finance')</h1>
</section>

<section class="content">
    <style>
        .mf-summary { margin-top: 6px; }
        .mf-summary .mf-box { border-radius: 4px; padding: 10px 12px; font-weight: 700; border: 1px solid rgba(0,0,0,.06); }
        .mf-summary .mf-box small { display:block; font-weight: 700; opacity: .95; }
        .mf-summary .mf-income { background: #e9f7ef; color: #0f5132; }
        .mf-summary .mf-expense { background: #fdecea; color: #842029; }
        .mf-summary .mf-net { background: #e7f1ff; color: #084298; }
        .mf-summary .display_currency { font-weight: 800; }
    </style>

    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-12 text-right" style="margin-bottom:10px;">
                <a href="{{ route('mosque.finance.reports') }}" class="btn btn-default">
                    <i class="fa fa-chart-bar"></i> Reports
                </a>
                <a href="{{ route('mosque.finance.day_book') }}" class="btn btn-default">
                    <i class="fa fa-book"></i> Day Book
                </a>
                <a href="{{ route('mosque.finance.cash_book') }}" class="btn btn-default">
                    <i class="fa fa-calculator"></i> Cash Book
                </a>
                @if(auth()->user()->hasAnyPermission(['mosque.finance.income','mosque.finance.expense','mosque.finance.reports']))
                    <button type="button" class="btn btn-info btn-modal" data-href="{{ route('mosque.finance.opening_balance.create') }}" data-container=".mosque_opening_balance_modal">
                        <i class="fa fa-flag"></i> Opening Balance
                    </button>
                    <button type="button" class="btn btn-default btn-modal" data-href="{{ route('mosque.finance.opening_balance.history') }}" data-container=".mosque_opening_balance_history_modal">
                        <i class="fa fa-history"></i>
                    </button>
                @endif
                @if(auth()->user()->hasAnyPermission(['mosque.finance.income','mosque.finance.reports']))
                    <button type="button" class="btn btn-success btn-modal" data-href="{{ route('mosque.finance.entries.create', ['type' => 'income']) }}" data-container=".mosque_finance_entry_modal">
                        <i class="fa fa-plus"></i> Add Income
                    </button>
                @endif
                @if(auth()->user()->hasAnyPermission(['mosque.finance.expense','mosque.finance.reports']))
                    <button type="button" class="btn btn-danger btn-modal" data-href="{{ route('mosque.finance.entries.create', ['type' => 'expense']) }}" data-container=".mosque_finance_entry_modal">
                        <i class="fa fa-minus"></i> Add Expense
                    </button>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col-sm-3" style="display:none;">
                <div class="form-group">
                    <label>@lang('lang_v1.start_date')</label>
                    <input type="date" id="mf_start_date" class="form-control" value="{{ now()->startOfMonth()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-3" style="display:none;">
                <div class="form-group">
                    <label>@lang('lang_v1.end_date')</label>
                    <input type="date" id="mf_end_date" class="form-control" value="{{ now()->endOfMonth()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-4">
                <div class="form-group">
                    <label>@lang('report.date_range')</label>
                    <input type="text" id="mf_date_range" class="form-control" readonly autocomplete="off" placeholder="@lang('lang_v1.select_a_date_range')">
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('lang_v1.type')</label>
                    <select id="mf_type" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="income">Income</option>
                        <option value="expense">Expense</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('lang_v1.source')</label>
                    <select id="mf_source" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="module">Module</option>
                        <option value="core_sale">Core Sale</option>
                        <option value="core_purchase">Core Purchase</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="form-group">
                    <label>@lang('product.category')</label>
                    <select id="mf_category_id" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        @foreach($categories as $cat)
                            <option value="{{ $cat->id }}">{{ ucfirst($cat->type) }} - {{ $cat->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="row mf-summary">
            <div class="col-sm-4">
                <div class="mf-box mf-income">
                    <small>Income</small>
                    <span id="mf_total_income" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="mf-box mf-expense">
                    <small>Expense</small>
                    <span id="mf_total_expense" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="mf-box mf-net">
                    <small>Net</small>
                    <span id="mf_total_net" class="display_currency" data-currency_symbol="true">0</span>
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_finance_table" style="width: 100%;">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Category</th>
                        <th>Source</th>
                        <th>Ref</th>
                        <th>Note</th>
                        <th>Paid</th>
                        <th>Due</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
        <div class="text-right text-muted" id="mosque_finance_table_count" style="margin-top:6px;"></div>
    @endcomponent

    <div class="modal fade mosque_finance_entry_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_opening_balance_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_opening_balance_history_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

    <div class="modal fade" id="mosque_finance_confirm_delete_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_finance_confirm_delete_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_finance_confirm_delete_modal_label">@lang('messages.delete')</h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:6px;">Permanent delete: removes this finance entry and it will not remain in any reports or dashboard (only audit logs remain).</p>
                    <p>Type <strong>Confirm</strong> (case-sensitive) to delete.</p>
                    <div class="form-group">
                        <input type="text" class="form-control" id="mosque_finance_confirm_delete_input" placeholder="Confirm" autocomplete="off">
                        <input type="hidden" id="mosque_finance_confirm_delete_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_finance_confirm_delete_btn">@lang('messages.delete')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        $('body').tooltip({selector: '[data-toggle="tooltip"]'});

        function resetFiltersToDefault() {
            var s = moment().startOf('year');
            var e = moment().endOf('year');
            $('#mf_start_date').val(s.format('YYYY-MM-DD'));
            $('#mf_end_date').val(e.format('YYYY-MM-DD'));
            $('#mf_type').val('').trigger('change');
            $('#mf_source').val('').trigger('change');
            $('#mf_category_id').val('').trigger('change');
            if ($('#mf_date_range').length && typeof moment_date_format !== 'undefined') {
                $('#mf_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
            }
        }

        // Force defaults on reload (avoid browser restoring old values).
        resetFiltersToDefault();

        // Date range filter (like core POS)
        if (typeof dateRangeSettings !== 'undefined' && $('#mf_date_range').length) {
            var start = moment($('#mf_start_date').val(), 'YYYY-MM-DD');
            var end = moment($('#mf_end_date').val(), 'YYYY-MM-DD');
            $('#mf_date_range').daterangepicker(
                $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
                function (s, e) {
                    $('#mf_start_date').val(s.format('YYYY-MM-DD'));
                    $('#mf_end_date').val(e.format('YYYY-MM-DD'));
                    $('#mf_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                    finance_table.ajax.reload();
                    refreshSummary();
                }
            );
            $('#mf_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            $('#mf_date_range').on('cancel.daterangepicker', function() {
                // Reset to this year
                var s = moment().startOf('year');
                var e = moment().endOf('year');
                $('#mf_start_date').val(s.format('YYYY-MM-DD'));
                $('#mf_end_date').val(e.format('YYYY-MM-DD'));
                $('#mf_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                finance_table.ajax.reload();
                refreshSummary();
            });
        }

        function getFilters() {
            return {
                start_date: $('#mf_start_date').val(),
                end_date: $('#mf_end_date').val(),
                type: $('#mf_type').val(),
                source: $('#mf_source').val(),
                category_id: $('#mf_category_id').val(),
            };
        }

        function refreshSummary() {
            $.ajax({
                method: 'GET',
                url: '{{ route("mosque.finance.summary") }}',
                data: getFilters(),
                success: function (result) {
                    if (result && result.success) {
                        $('#mf_total_income').attr('data-orig-value', result.totals.income).text(result.totals.income);
                        $('#mf_total_expense').attr('data-orig-value', result.totals.expense).text(result.totals.expense);
                        $('#mf_total_net').attr('data-orig-value', result.net).text(result.net);
                        __currency_convert_recursively($('.content'));
                    }
                }
            });
        }

        var finance_table = $('#mosque_finance_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.finance.data") }}',
                data: function (d) {
                    return $.extend({}, d, getFilters());
                }
            },
            lengthMenu: [
                [25, 50, 100, 200, -1],
                [25, 50, 100, 200, @json(__('lang_v1.all'))]
            ],
            pageLength: 25,
            order: [[0, 'desc']],
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'date', name: 'date' },
                { data: 'type', name: 'type' },
                { data: 'category', name: 'category' },
                { data: 'source_label', name: 'source_label', orderable: false, searchable: false },
                { data: 'ref_no', name: 'ref_no', orderable: false, searchable: false },
                { data: 'note', name: 'note', orderable: false, searchable: true },
                { data: 'paid_amount', name: 'paid_amount', orderable: false, searchable: false },
                { data: 'due_amount', name: 'due_amount', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_finance_table'));
                var info = finance_table ? finance_table.page.info() : null;
                if (info) {
                    $('#mosque_finance_table_count').text('Total rows: ' + info.recordsDisplay);
                }
            }
        });

        finance_table.on('init.dt', function () {
            $('#mosque_finance_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        // Ensure defaults also apply on BFCache restores (Back/Forward + some reload flows).
        window.addEventListener('pageshow', function () {
            resetFiltersToDefault();
            if ($('#mf_date_range').data('daterangepicker')) {
                var s = moment($('#mf_start_date').val(), 'YYYY-MM-DD');
                var e = moment($('#mf_end_date').val(), 'YYYY-MM-DD');
                $('#mf_date_range').data('daterangepicker').setStartDate(s);
                $('#mf_date_range').data('daterangepicker').setEndDate(e);
                $('#mf_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
            }
            finance_table.ajax.reload();
            refreshSummary();
        });

        $(document).on('change', '#mf_type, #mf_source, #mf_category_id', function () {
            finance_table.ajax.reload();
            refreshSummary();
        });

        $(document).on('submit', 'form#mosque_finance_entry_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_finance_entry_modal').modal('hide');
                        toastr.success(result.msg);
                        finance_table.ajax.reload();
                        refreshSummary();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('submit', 'form#mosque_opening_balance_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success || result.ok) {
                        $('.mosque_opening_balance_modal').modal('hide');
                        toastr.success(result.msg || result.toast || '@lang("lang_v1.success")');
                        finance_table.ajax.reload();
                        refreshSummary();
                    } else {
                        toastr.error(result.msg || result.toast || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function (xhr) {
                    var msg = '@lang("messages.something_went_wrong")';
                    if (xhr && xhr.responseJSON && xhr.responseJSON.message) {
                        msg = xhr.responseJSON.message;
                    }
                    toastr.error(msg);
                }
            });
        });

        function initOpeningBalanceHistoryModal() {
            if (!$('#mosque_opening_balance_table').length) {
                return;
            }
            if ($.fn.DataTable.isDataTable('#mosque_opening_balance_table')) {
                return;
            }

            function resetObFiltersToDefault() {
                var s = moment().startOf('year');
                var e = moment().endOf('year');
                $('#ob_start_date').val(s.format('YYYY-MM-DD'));
                $('#ob_end_date').val(e.format('YYYY-MM-DD'));
                $('#ob_type').val('');
                if ($('#ob_date_range').length && typeof moment_date_format !== 'undefined') {
                    $('#ob_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                }
            }

            resetObFiltersToDefault();

            if (typeof dateRangeSettings !== 'undefined' && $('#ob_date_range').length) {
                var start = moment($('#ob_start_date').val(), 'YYYY-MM-DD');
                var end = moment($('#ob_end_date').val(), 'YYYY-MM-DD');
                $('#ob_date_range').daterangepicker(
                    $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
                    function (s, e) {
                        $('#ob_start_date').val(s.format('YYYY-MM-DD'));
                        $('#ob_end_date').val(e.format('YYYY-MM-DD'));
                        $('#ob_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                        obTable.ajax.reload();
                    }
                );
                $('#ob_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            }

            function getObFilters() {
                return {
                    start_date: $('#ob_start_date').val(),
                    end_date: $('#ob_end_date').val(),
                    type: $('#ob_type').val()
                };
            }

            var obTable = $('#mosque_opening_balance_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("mosque.finance.opening_balance.data") }}',
                    data: function (d) {
                        return $.extend({}, d, getObFilters());
                    }
                },
                order: [[0, 'desc']],
                pageLength: 25,
                columns: [
                    { data: 'entry_date', name: 'entry_date' },
                    { data: 'type', name: 'type' },
                    { data: 'category', name: 'category' },
                    { data: 'amount', name: 'amount', orderable: false, searchable: false },
                    { data: 'note', name: 'note' },
                    { data: 'created_at', name: 'created_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false }
                ],
                drawCallback: function () {
                    __currency_convert_recursively($('#mosque_opening_balance_table'));
                    var info = obTable ? obTable.page.info() : null;
                    if (info) {
                        $('#mosque_opening_balance_table_count').text('Total rows: ' + info.recordsDisplay);
                    }
                }
            });

            $(document).on('change', '#ob_type', function () {
                obTable.ajax.reload();
            });
        }

        $(document).on('shown.bs.modal', '.mosque_opening_balance_history_modal', function () {
            initOpeningBalanceHistoryModal();
        });

        $(document).on('click', '.delete_mosque_finance_entry', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $('#mosque_finance_confirm_delete_url').val(href);
            $('#mosque_finance_confirm_delete_input').val('');
            $('#mosque_finance_confirm_delete_modal').modal('show');
        });

        $('#mosque_finance_confirm_delete_btn').on('click', function () {
            var txt = ($('#mosque_finance_confirm_delete_input').val() || '').trim();
            if (txt !== 'Confirm' && txt !== 'CONFIRM') {
                toastr.error('Please type Confirm (case-sensitive).');
                return;
            }
            var href = $('#mosque_finance_confirm_delete_url').val();
            $.ajax({
                method: 'DELETE',
                url: href,
                data: { _token: '{{ csrf_token() }}' },
                success: function (result) {
                    if (result.success || result.ok) {
                        $('#mosque_finance_confirm_delete_modal').modal('hide');
                        toastr.success(result.msg || result.toast || '@lang("lang_v1.success")');
                        finance_table.ajax.reload();
                        refreshSummary();
                    } else {
                        toastr.error(result.msg || result.toast || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        refreshSummary();
    });
</script>
@endsection
