<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.finance.opening_balance.store'), 'method' => 'post', 'id' => 'mosque_opening_balance_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Opening Balance</h4>
        </div>
        <div class="modal-body">
            <p class="help-block" style="margin-bottom:10px;">
                Use this once when starting the Mosque Finance module to enter previous totals (before using the system).
                It will affect Day Book/Cash Book opening balance and dashboard totals.
            </p>
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('as_of_date', 'As of date' . ':*') !!}
                        {!! Form::date('as_of_date', \Carbon\Carbon::now()->format('Y-m-d'), ['class' => 'form-control', 'required']) !!}
                        <p class="help-block" style="margin-top:4px;">This will be added on this date and will reflect in Finance/Dashboard/Reports within your selected date range.</p>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('opening_income', 'Opening Income') !!}
                        {!! Form::number('opening_income', 0, ['class' => 'form-control', 'step' => '0.01', 'min' => '0']) !!}
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('opening_expense', 'Opening Expense') !!}
                        {!! Form::number('opening_expense', 0, ['class' => 'form-control', 'step' => '0.01', 'min' => '0']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('note', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('note', null, ['class' => 'form-control', 'rows' => 2, 'placeholder' => 'Optional note (e.g., previous years summary)']) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>
