<div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Opening Balance History</h4>
        </div>
        <div class="modal-body">
            <p class="help-block" style="margin-bottom:10px;">
                If you don’t see an entry, expand the Date Range. Opening Balance entries are stored by the “As of date” you selected.
            </p>
            <div class="row">
                <div class="col-sm-5">
                    <div class="form-group">
                        <label>@lang('report.date_range')</label>
                        <input type="text" id="ob_date_range" class="form-control" readonly autocomplete="off">
                        <input type="hidden" id="ob_start_date" value="{{ now()->startOfYear()->format('Y-m-d') }}">
                        <input type="hidden" id="ob_end_date" value="{{ now()->endOfYear()->format('Y-m-d') }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('lang_v1.type')</label>
                        <select id="ob_type" class="form-control">
                            <option value="">@lang('lang_v1.all')</option>
                            <option value="income">Income</option>
                            <option value="expense">Expense</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-4 text-right" style="padding-top:24px;">
                    <button type="button" class="btn btn-info btn-modal" data-href="{{ route('mosque.finance.opening_balance.create') }}" data-container=".mosque_opening_balance_modal">
                        <i class="fa fa-plus"></i> Add Opening Balance
                    </button>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="mosque_opening_balance_table" style="width:100%;">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Category</th>
                            <th>Amount</th>
                            <th>Note</th>
                            <th>Created</th>
                            <th>@lang('messages.action')</th>
                        </tr>
                    </thead>
                </table>
            </div>
            <div class="text-right text-muted" id="mosque_opening_balance_table_count" style="margin-top:6px;"></div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>

