@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.bank_menu_transfers'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.bank_menu_transfers')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row" style="margin-bottom:10px;">
            <div class="col-sm-12 text-right">
                <a href="{{ route('mosque.finance') }}" class="btn btn-default"><i class="fa fa-arrow-left"></i> @lang('messages.back')</a>
            </div>
        </div>

        <form id="mosque_net_to_bank_form">
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.bank_bank_account') *</label>
                        <select name="bank_account_id" class="form-control" required>
                            <option value="">@lang('lang_v1.please_select')</option>
                            @foreach(($banks ?? []) as $id => $label)
                                <option value="{{ $id }}">{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.bank_amount') *</label>
                        <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>@lang('lang_v1.date') *</label>
                        <input type="date" name="transfer_date" class="form-control" value="{{ now()->format('Y-m-d') }}" required>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('lang_v1.note')</label>
                        <input type="text" name="note" class="form-control" placeholder="@lang('lang_v1.note')">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 text-right">
                    <button type="submit" class="btn btn-primary"><i class="fa fa-exchange"></i> @lang('mosque::mosque.bank_transfer_to_bank')</button>
                </div>
            </div>
        </form>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="row" style="margin-bottom:10px;">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('report.date_range')</label>
                    <input type="text" id="mbt_date_range" class="form-control" readonly autocomplete="off" placeholder="@lang('lang_v1.select_a_date_range')">
                    <input type="hidden" id="mbt_start_date" value="{{ now()->startOfYear()->format('Y-m-d') }}">
                    <input type="hidden" id="mbt_end_date" value="{{ now()->endOfYear()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('mosque::mosque.bank_bank_account')</label>
                    <select id="mbt_bank_account_id" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        @foreach(($banks ?? []) as $id => $label)
                            <option value="{{ $id }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('lang_v1.status')</label>
                    <select id="mbt_status" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="completed">@lang('lang_v1.completed')</option>
                        <option value="voided">@lang('lang_v1.voided')</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_net_bank_transfers_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('lang_v1.date')</th>
                        <th>@lang('mosque::mosque.bank_bank_account')</th>
                        <th>@lang('mosque::mosque.bank_amount')</th>
                        <th>@lang('lang_v1.note')</th>
                        <th>@lang('lang_v1.status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
$(function () {
    function resetTransferFilters() {
        var s = moment().startOf('year');
        var e = moment().endOf('year');
        $('#mbt_start_date').val(s.format('YYYY-MM-DD'));
        $('#mbt_end_date').val(e.format('YYYY-MM-DD'));
        if ($('#mbt_date_range').length && typeof moment_date_format !== 'undefined') {
            $('#mbt_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
        }
    }

    resetTransferFilters();

    if (typeof dateRangeSettings !== 'undefined' && $('#mbt_date_range').length) {
        var start = moment($('#mbt_start_date').val(), 'YYYY-MM-DD');
        var end = moment($('#mbt_end_date').val(), 'YYYY-MM-DD');
        $('#mbt_date_range').daterangepicker(
            $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
            function (s, e) {
                $('#mbt_start_date').val(s.format('YYYY-MM-DD'));
                $('#mbt_end_date').val(e.format('YYYY-MM-DD'));
                $('#mbt_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                table.ajax.reload();
            }
        );
        $('#mbt_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
    }

    var table = $('#mosque_net_bank_transfers_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.finance.transfers.data") }}',
            data: function (d) {
                d.start_date = $('#mbt_start_date').val();
                d.end_date = $('#mbt_end_date').val();
                d.bank_account_id = $('#mbt_bank_account_id').val();
                d.status = $('#mbt_status').val();
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'transfer_date', name: 'transfer_date' },
            { data: 'bank', name: 'bank_name', orderable: false, searchable: true },
            { data: 'amount', name: 'amount', orderable: false, searchable: false },
            { data: 'note', name: 'note' },
            { data: 'status', name: 'status' },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
    });

    $('#mbt_bank_account_id, #mbt_status').on('change', function () {
        table.ajax.reload();
    });

    $('#mosque_net_to_bank_form').on('submit', function (e) {
        e.preventDefault();
        $.ajax({
            method: 'POST',
            url: '{{ route("mosque.finance.transfers.store") }}',
            data: $(this).serialize(),
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    toastr.success(res.msg || LANG.success);
                    table.ajax.reload();
                } else {
                    toastr.error(res.msg || LANG.something_went_wrong);
                }
            },
            error: function () {
                toastr.error(LANG.something_went_wrong);
            }
        });
    });
});
</script>
@endsection
