<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.members.store'), 'method' => 'post', 'id' => 'mosque_member_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.add')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('name', __('user.name') . ':*') !!}
                        {!! Form::text('name', null, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('status', __('sale.status') . ':*') !!}
                        {!! Form::select('status', ['Active' => 'Active', 'Inactive' => 'Inactive', 'Deceased' => 'Deceased', 'Migrated' => 'Migrated'], 'Active', ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('phone', __('contact.mobile') . ':') !!}
                        {!! Form::text('phone', null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('whatsapp_number', 'WhatsApp:') !!}
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-whatsapp"></i></span>
                            {!! Form::text('whatsapp_number', null, ['class' => 'form-control', 'id' => 'mosque_member_whatsapp_number', 'placeholder' => __('contact.mobile')]) !!}
                        </div>
                        <div class="checkbox" style="margin-top:5px;">
                            <label style="margin:0;">
                                {!! Form::hidden('whatsapp_same_as_phone', 0) !!}
                                <input type="checkbox" id="mosque_member_whatsapp_same" name="whatsapp_same_as_phone" value="1" checked>
                                Same as mobile
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('email', __('business.email') . ':') !!}
                        {!! Form::email('email', null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <hr style="margin:8px 0 12px;">
                </div>
                <div class="col-sm-12">
                    <h4 style="margin-top:0;margin-bottom:10px;">Membership Billing</h4>
                </div>
                <div class="col-sm-6">
                    <div class="checkbox" style="margin-top:0;">
                        <label>
                            {!! Form::hidden('billing_enabled', 0) !!}
                            <input type="checkbox" id="mosque_member_billing_enabled" name="billing_enabled" value="1">
                            Enable membership fees for this member
                        </label>
                    </div>
                </div>
                <div class="col-sm-6"></div>
                <div class="col-sm-6 mosque_member_billing_fields" style="display:none;">
                    <div class="form-group">
                        {!! Form::label('membership_plan_id', 'Fees Plan:*') !!}
                        {!! Form::select('membership_plan_id', $plans ?? [], null, ['class' => 'form-control mosque_member_plan_select', 'id' => 'mosque_member_plan_id', 'placeholder' => __('lang_v1.none')]) !!}
                        <p class="help-block">Monthly/Yearly based on plan type.</p>
                    </div>
                </div>
                <div class="col-sm-6 mosque_member_billing_fields" style="display:none;">
                    <div class="form-group">
                        {!! Form::label('billing_start_ym', 'Billing Start (YYYY-MM):') !!}
                        <input type="text" name="billing_start_ym" id="mosque_member_billing_start_ym" class="form-control mosque_monthpicker" placeholder="YYYY-MM" autocomplete="off">
                        <p class="help-block">If blank, you can set it later in Generate Fees.</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('address', __('business.address') . ':') !!}
                        {!! Form::textarea('address', null, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('notes', null, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script type="text/javascript">
    (function () {
        function syncWhatsapp() {
            var same = $('#mosque_member_whatsapp_same').is(':checked');
            $('#mosque_member_whatsapp_number').prop('readonly', same);
            if (same) {
                $('#mosque_member_whatsapp_number').val($('input[name="phone"]').val());
            }
        }

        function syncBilling() {
            var enabled = $('#mosque_member_billing_enabled').is(':checked');
            $('.mosque_member_billing_fields').toggle(enabled);
        }

        $(document).on('change', '#mosque_member_whatsapp_same', syncWhatsapp);
        $(document).on('keyup change', 'input[name="phone"]', function () {
            if ($('#mosque_member_whatsapp_same').is(':checked')) {
                $('#mosque_member_whatsapp_number').val($(this).val());
            }
        });

        $(document).on('change', '#mosque_member_billing_enabled', syncBilling);

        $(document).ready(syncWhatsapp);
        $(document).ready(syncBilling);
    })();
</script>
