@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_members'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_members')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('sale.status')</label>
                    <select id="mm_status" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="Active">Active</option>
                        <option value="Inactive">Inactive</option>
                        <option value="Deceased">Deceased</option>
                        <option value="Migrated">Migrated</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Family Code</label>
                    <select id="mm_family_code" class="form-control" style="width:100%;"></select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Fees Plan</label>
                    {!! Form::select('mm_plan_id', $planOptions ?? [], null, ['class' => 'form-control', 'id' => 'mm_plan_id', 'placeholder' => __('lang_v1.all')]) !!}
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Billing Cycle</label>
                    <select id="mm_billing_cycle" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="monthly">Monthly</option>
                        <option value="yearly">Yearly</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Billing Start</label>
                    <input type="text" id="mm_billing_start_ym" class="form-control mosque_monthpicker" placeholder="YYYY-MM" autocomplete="off">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Billing Enabled</label>
                    <select id="mm_billing_enabled" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="yes">Yes</option>
                        <option value="no">No</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-12 text-right">
                <a href="{{ route('mosque.families') }}" class="btn btn-default">
                    <i class="fa fa-home"></i> Families
                </a>
                <a href="{{ route('mosque.members.reports') }}" class="btn btn-default">
                    <i class="fa fa-bar-chart"></i> @lang('mosque::mosque.menu_members_reports')
                </a>
                <button type="button" class="btn btn-default btn-modal" data-href="{{ route('mosque.members.import') }}" data-container=".mosque_member_import_modal">
                    <i class="fa fa-upload"></i> Import
                </button>
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.members.create') }}" data-container=".mosque_member_modal">
                    <i class="fa fa-plus"></i> @lang('messages.add')
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_members_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('user.name')</th>
                        <th>Family Code(s)</th>
                        <th>Fees Plan</th>
                        <th>Billing Cycle</th>
                        <th>Billing Start</th>
                        <th>@lang('contact.mobile')</th>
                        <th>WhatsApp</th>
                        <th>@lang('business.email')</th>
                        <th>@lang('sale.status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_member_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_member_import_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        $('.mosque_monthpicker').datepicker({
            autoclose: true,
            format: 'yyyy-mm',
            minViewMode: 1,
            startView: 1
        });

        $('#mm_family_code').select2({
            width: '100%',
            tags: true,
            allowClear: true,
            placeholder: 'Search family code',
            minimumInputLength: 0,
            minimumResultsForSearch: 0,
            ajax: {
                url: '{{ route("mosque.families.codes.search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { q: params.term || '' };
                },
                processResults: function (data) {
                    return { results: (data && data.results) ? data.results : [] };
                },
                cache: true
            }
        });

        var members_table = $('#mosque_members_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.members.data") }}',
                data: function (d) {
                    d.status = $('#mm_status').val();
                    d.family_code = $('#mm_family_code').val();
                    d.plan_id = $('#mm_plan_id').val();
                    d.billing_cycle = $('#mm_billing_cycle').val();
                    d.billing_start_ym = $('#mm_billing_start_ym').val();
                    d.billing_enabled = $('#mm_billing_enabled').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'family_codes', name: 'family_codes', orderable: false, searchable: false },
                { data: 'fees_plan_name', name: 'fees_plan_name', orderable: false, searchable: false },
                { data: 'billing_cycle', name: 'billing_cycle', orderable: false, searchable: false },
                { data: 'billing_start_ym', name: 'billing_start_ym', orderable: false, searchable: false },
                { data: 'phone', name: 'phone' },
                { data: 'whatsapp_number', name: 'whatsapp_number', orderable: false, searchable: false },
                { data: 'email', name: 'email' },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
        });

        members_table.on('init.dt', function () {
            $('#mosque_members_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('change', '#mm_status, #mm_family_code, #mm_plan_id, #mm_billing_cycle, #mm_billing_start_ym, #mm_billing_enabled', function () {
            members_table.ajax.reload();
        });

        $(document).on('shown.bs.modal', '.mosque_member_modal', function () {
            var $modal = $(this);

            $modal.find('.mosque_monthpicker').datepicker({
                autoclose: true,
                format: 'yyyy-mm',
                minViewMode: 1,
                startView: 1
            });

            var $plan = $modal.find('#mosque_member_plan_id');
            if ($plan.length && ! $plan.hasClass('select2-hidden-accessible')) {
                $plan.select2({
                    width: '100%',
                    allowClear: true,
                    dropdownParent: $modal,
                    placeholder: '@lang("lang_v1.none")',
                });
            }
        });

        $(document).on('submit', 'form#mosque_member_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_member_modal').modal('hide');
                        toastr.success(result.msg);
                        members_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('submit', 'form#mosque_member_import_form', function (e) {
            e.preventDefault();
            var formEl = this;
            var formData = new FormData(formEl);

            $.ajax({
                method: 'POST',
                url: $(formEl).attr('action'),
                data: formData,
                contentType: false,
                processData: false,
                success: function (result) {
                    if (result.success) {
                        $('.mosque_member_import_modal').modal('hide');
                        toastr.success(result.msg);
                        members_table.ajax.reload();
                    } else {
                        toastr.error(result.msg || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.delete_mosque_member', function (e) {
            e.preventDefault();
            var href = $(this).data('href');

            swal({
                title: LANG.sure,
                icon: 'warning',
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        method: 'DELETE',
                        url: href,
                        data: { _token: '{{ csrf_token() }}' },
                        success: function (result) {
                            if (result.success) {
                                toastr.success(result.msg);
                                members_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
    });
</script>
@endsection
